/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormapping.implementation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.colormapping.DataFrameColorMapFactory;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColor;
import org.mkui.colormap.ColorMap;
import org.mkui.colormap.ColorMapEvent;
import org.mkui.colormap.ColorMapFactory;
import org.mkui.colormap.ColorMapListener;
import org.mkui.colormap.MutableColorMap;
import org.mkui.colormapping.AbstractColorMapping;
import org.mkui.colormapping.MutableColorMapping;
import org.molap.dataframe.DataFrame;
import org.molap.series.Series;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(H\u0096\u0002J\u0017\u0010)\u001a\u0004\u0018\u00010\u00172\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010+J\u001f\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00028\u00012\b\u0010.\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010/J\u0017\u00100\u001a\u0004\u0018\u00010\u00172\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010+J\u0015\u00101\u001a\u00020\u00172\u0006\u0010*\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010+J\u0017\u00102\u001a\u0004\u0018\u00010\u00172\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010+J\u0017\u00103\u001a\u0004\u0018\u00010\u00172\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010+J\u0015\u00104\u001a\u00020\u00172\u0006\u0010*\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010+J\u0017\u00105\u001a\u0004\u0018\u00010\u001c2\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00106J\u001b\u00107\u001a\b\u0012\u0002\b\u0003\u0018\u0001082\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00109J\u0017\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010<J\u0017\u0010=\u001a\u0004\u0018\u00010;2\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010<J\u001d\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0?2\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010AJ\u0006\u0010B\u001a\u00020-R&\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001c0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006C"}, d2={"Lcom/macrofocus/colormapping/implementation/SimpleColorMapping;", "R", "C", "Lorg/mkui/colormapping/AbstractColorMapping;", "Lorg/mkui/colormapping/MutableColorMapping;", "factory", "Lorg/mkui/colormap/ColorMapFactory;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "<init>", "(Lorg/mkui/colormap/ColorMapFactory;Lorg/molap/dataframe/DataFrame;)V", "active", "", "isActive", "()Z", "setActive", "(Z)V", "colorSelection", "Lcom/macrofocus/common/selection/MutableSingleSelection;", "getColorSelection", "()Lcom/macrofocus/common/selection/MutableSingleSelection;", "currentColorMaps", "", "Lorg/mkui/colormap/MutableColorMap;", "categoricalColorMaps", "predefinedColorMaps", "customColorMaps", "boundedIntervalMap", "Lcom/macrofocus/common/interval/MutableBoundedInterval;", "colorMapListener", "Lorg/mkui/colormap/ColorMapListener;", "singleSelectionListener", "Lcom/macrofocus/common/selection/SingleSelectionListener;", "getSingleSelectionListener", "()Lcom/macrofocus/common/selection/SingleSelectionListener;", "getColor", "Lorg/mkui/color/MkColor;", "element", "(Ljava/lang/Object;)Lorg/mkui/color/MkColor;", "iterator", "", "getCurrentColorMap", "column", "(Ljava/lang/Object;)Lorg/mkui/colormap/MutableColorMap;", "setCurrentColorMap", "", "colorMap", "(Ljava/lang/Object;Lorg/mkui/colormap/MutableColorMap;)V", "getCategoricalColorMap", "createQualitativeColorMap", "getCustomColorMap", "getPredefinedColorMap", "createPredefinedColorMap", "getCurrentBoundedInterval", "(Ljava/lang/Object;)Lcom/macrofocus/common/interval/MutableBoundedInterval;", "getFormat", "Lcom/macrofocus/common/format/CPFormat;", "(Ljava/lang/Object;)Lcom/macrofocus/common/format/CPFormat;", "getNumericMin", "", "(Ljava/lang/Object;)Ljava/lang/Number;", "getNumericMax", "getType", "Lkotlin/reflect/KClass;", "", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "resetRanges", "mkui-molap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSimpleColorMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleColorMapping.kt\ncom/macrofocus/colormapping/implementation/SimpleColorMapping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
public final class SimpleColorMapping<R, C>
extends AbstractColorMapping<R, C>
implements MutableColorMapping<R, C> {
    private boolean isActive;
    @NotNull
    private final DataFrame<R, C, ?> dataFrame;
    @NotNull
    private final ColorMapFactory factory;
    @NotNull
    private final MutableSingleSelection<C> colorSelection;
    @NotNull
    private final Map<C, MutableColorMap> currentColorMaps;
    @NotNull
    private final Map<C, MutableColorMap> categoricalColorMaps;
    @NotNull
    private final Map<C, MutableColorMap> predefinedColorMaps;
    @NotNull
    private final Map<C, MutableColorMap> customColorMaps;
    @NotNull
    private final Map<C, MutableBoundedInterval> boundedIntervalMap;
    @NotNull
    private final ColorMapListener colorMapListener;
    @NotNull
    private final SingleSelectionListener<C> singleSelectionListener;
    public static final int $stable = 8;

    public SimpleColorMapping(@NotNull ColorMapFactory factory, @NotNull DataFrame<R, C, ?> dataFrame) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        this.currentColorMaps = new HashMap();
        this.categoricalColorMaps = new HashMap();
        this.predefinedColorMaps = new HashMap();
        this.customColorMaps = new HashMap();
        this.boundedIntervalMap = new HashMap();
        this.colorMapListener = new ColorMapListener(this){
            final /* synthetic */ SimpleColorMapping<R, C> this$0;
            {
                this.this$0 = $receiver;
            }

            public void colorMapChanged(ColorMapEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                SimpleColorMapping.access$notifyColormappingChanged(this.this$0);
            }
        };
        this.singleSelectionListener = new SingleSelectionListener<C>(this){
            final /* synthetic */ SimpleColorMapping<R, C> this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(SingleSelectionEvent<C> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                SimpleColorMapping.access$notifyColormappingChanged(this.this$0);
            }
        };
        this.dataFrame = dataFrame;
        this.factory = factory;
        this.colorSelection = (MutableSingleSelection)new SimpleSingleSelection();
        ((SimpleSingleSelection)this.getColorSelection()).addSingleSelectionListener(this.singleSelectionListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive() {
        if (!this.getColorSelection().isActive()) return false;
        Object object = this.getColorSelection().getSelected();
        if (object == null) return false;
        Object it = object;
        boolean bl = false;
        MutableColorMap mutableColorMap = this.getCurrentColorMap(it);
        if (mutableColorMap == null) return false;
        return true;
    }

    public void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.notifyColormappingChanged();
        }
    }

    @NotNull
    public MutableSingleSelection<C> getColorSelection() {
        return this.colorSelection;
    }

    @NotNull
    public final SingleSelectionListener<C> getSingleSelectionListener() {
        return this.singleSelectionListener;
    }

    @Nullable
    public MkColor getColor(R element) {
        MkColor mkColor;
        Object object = this.getColorSelection().getSelected();
        Intrinsics.checkNotNull((Object)object);
        ColorMap colorMap = (ColorMap)this.getCurrentColorMap(object);
        if (colorMap != null) {
            Object object2 = this.getColorSelection().getSelected();
            Intrinsics.checkNotNull((Object)object2);
            Object value = this.dataFrame.getValueAt(element, object2);
            mkColor = colorMap.getColor(value);
        } else {
            mkColor = null;
        }
        return mkColor;
    }

    @NotNull
    public Iterator<R> iterator() {
        return this.isActive() ? this.dataFrame.rows().iterator() : CollectionsKt.emptyList().iterator();
    }

    @Nullable
    public MutableColorMap getCurrentColorMap(C column) {
        MutableColorMap mutableColorMap;
        if (column != null) {
            if (!this.currentColorMaps.containsKey(column)) {
                if (this.getNumericMin(column) != null && this.getNumericMax(column) != null) {
                    this.setCurrentColorMap(column, this.getPredefinedColorMap(column));
                } else {
                    this.setCurrentColorMap(column, this.getCategoricalColorMap(column));
                }
            }
            mutableColorMap = this.currentColorMaps.get(column);
        } else {
            mutableColorMap = null;
        }
        return mutableColorMap;
    }

    public void setCurrentColorMap(C column, @Nullable MutableColorMap colorMap) {
        if (this.currentColorMaps.get(column) != colorMap) {
            if (this.currentColorMaps.containsKey(column)) {
                MutableColorMap mutableColorMap = this.currentColorMaps.get(column);
                Intrinsics.checkNotNull((Object)mutableColorMap);
                mutableColorMap.removeColorMapListener(this.colorMapListener);
            }
            if (colorMap != null) {
                this.currentColorMaps.put(column, colorMap);
                colorMap.addColorMapListener(this.colorMapListener);
            } else {
                this.currentColorMaps.remove(column);
            }
            this.notifyColormappingChanged();
        }
    }

    @Nullable
    public MutableColorMap getCategoricalColorMap(C column) {
        if (!this.categoricalColorMaps.containsKey(column)) {
            this.categoricalColorMaps.put(column, this.createQualitativeColorMap(column));
        }
        return this.categoricalColorMaps.get(column);
    }

    @NotNull
    protected final MutableColorMap createQualitativeColorMap(C column) {
        return DataFrameColorMapFactory.INSTANCE.createQualitativeColorMap(this.factory, this.dataFrame, column);
    }

    @Nullable
    public MutableColorMap getCustomColorMap(C column) {
        if (!this.customColorMaps.containsKey(column)) {
            this.customColorMaps.put(column, this.factory.createAutoSegmentedColorMap(this.getNumericMin(column), this.getNumericMax(column)));
        }
        return this.customColorMaps.get(column);
    }

    @Nullable
    public MutableColorMap getPredefinedColorMap(C column) {
        if (!this.predefinedColorMaps.containsKey(column)) {
            this.predefinedColorMaps.put(column, this.createPredefinedColorMap(column));
        }
        return this.predefinedColorMaps.get(column);
    }

    @NotNull
    protected final MutableColorMap createPredefinedColorMap(C column) {
        return this.factory.createAutoContinuousColorMap(this.getNumericMin(column), this.getNumericMax(column));
    }

    @Nullable
    public MutableBoundedInterval getCurrentBoundedInterval(C column) {
        if (!this.boundedIntervalMap.containsKey(column)) {
            MutableColorMap mutableColorMap = this.getCurrentColorMap(column);
            Intrinsics.checkNotNull((Object)mutableColorMap);
            MutableInterval mutableInterval = mutableColorMap.getInterval();
            Intrinsics.checkNotNull((Object)mutableInterval);
            Number number = this.getNumericMin(column);
            Intrinsics.checkNotNull((Object)number);
            double d = number.doubleValue();
            Number number2 = this.getNumericMax(column);
            Intrinsics.checkNotNull((Object)number2);
            MutableBoundedInterval boundedInterval = (MutableBoundedInterval)new SimpleBoundedInterval(mutableInterval, d, number2.doubleValue());
            this.boundedIntervalMap.put(column, boundedInterval);
        }
        return this.boundedIntervalMap.get(column);
    }

    @Nullable
    public CPFormat<?> getFormat(C column) {
        return null;
    }

    @Nullable
    public Number getNumericMin(C column) {
        Series series = this.dataFrame.getColumn(column);
        Object object = series != null ? series.min() : null;
        return object instanceof Number ? (Number)((Number)object) : (Number)null;
    }

    @Nullable
    public Number getNumericMax(C column) {
        Series series = this.dataFrame.getColumn(column);
        Object object = series != null ? series.max() : null;
        return object instanceof Number ? (Number)((Number)object) : (Number)null;
    }

    @NotNull
    public KClass<? extends Object> getType(C column) {
        return this.dataFrame.getColumnClass(column);
    }

    public final void resetRanges() {
        for (Map.Entry<C, MutableBoundedInterval> entry : this.boundedIntervalMap.entrySet()) {
            C key = entry.getKey();
            MutableBoundedInterval value = entry.getValue();
            Number numericMin = this.getNumericMin(key);
            Number numericMax = this.getNumericMax(key);
            if (numericMin == null || numericMax == null) continue;
            value.setMinMax(numericMin.doubleValue(), numericMax.doubleValue());
            value.setValue(numericMin.doubleValue(), numericMax.doubleValue() - numericMin.doubleValue());
        }
    }

    public static final /* synthetic */ void access$notifyColormappingChanged(SimpleColorMapping $this) {
        $this.notifyColormappingChanged();
    }
}

