/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.colormap.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.delegate.Delegate;
import com.macrofocus.common.delegate.MutableLazyKt;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.format.FormatFactory;
import com.macrofocus.common.math.MathKt;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.PropertySingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColor;
import org.mkui.color.MkColorKt;
import org.mkui.colormap.ColorMapFactory;
import org.mkui.colormap.MutableColorMap;
import org.mkui.colormap.editor.AbstractCustomColorMapEditor;
import org.mkui.colormap.editor.ColorCellRenderer;
import org.mkui.component.CPComponent;
import org.mkui.component.CPComponentProvider;
import org.mkui.component.CPFactory;
import org.mkui.component.button.CPCheckBox;
import org.mkui.component.button.CPRadioButtons;
import org.mkui.component.input.CPColorPicker;
import org.mkui.component.input.CPSlider;
import org.mkui.component.panel.CPFormPanel;
import org.mkui.component.panel.CPOverlayPanel;
import org.mkui.component.panel.CPVerticalFlowPanel;
import org.mkui.palette.CustomPalette;
import org.mkui.palette.InterpolatedPalette;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteEvent;
import org.mkui.palette.PaletteListener;
import org.mkui.table.Table;
import org.mkui.table.TableFactory;
import org.mkui.visual.Visual;
import org.molap.dataframe.AbstractMutableDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.MutableDataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;
import org.molap.series.Series;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u00012B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ>\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0010\u0010,\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010-H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Lorg/mkui/colormap/editor/CPCustomColorMapEditor;", "Lorg/mkui/colormap/editor/AbstractCustomColorMapEditor;", "Lorg/mkui/component/CPComponentProvider;", "factory", "Lorg/mkui/component/CPFactory;", "colorMapFactory", "Lorg/mkui/colormap/ColorMapFactory;", "tableFactory", "Lorg/mkui/table/TableFactory;", "<init>", "(Lorg/mkui/component/CPFactory;Lorg/mkui/colormap/ColorMapFactory;Lorg/mkui/table/TableFactory;)V", "mode", "Lcom/macrofocus/common/selection/MutableSingleSelection;", "Lorg/mkui/palette/CustomPalette$Mode;", "mainPanel", "Lorg/mkui/component/panel/CPVerticalFlowPanel;", "bandsRampsRadioButtons", "Lorg/mkui/component/button/CPRadioButtons;", "underflowColor", "Lorg/mkui/component/input/CPColorPicker;", "overflowColor", "missingValueColor", "table", "Lorg/mkui/table/Table;", "", "", "", "colorMapPreviewContainer", "Lorg/mkui/component/panel/CPOverlayPanel;", "brightnessSlider", "Lorg/mkui/component/input/CPSlider;", "saturationSlider", "overColorCheckBox", "Lorg/mkui/component/button/CPCheckBox;", "underColorCheckBox", "setColorMap", "", "colorMap", "Lorg/mkui/colormap/MutableColorMap;", "type", "Lkotlin/reflect/KClass;", "min", "", "max", "format", "Lcom/macrofocus/common/format/CPFormat;", "component", "Lorg/mkui/component/CPComponent;", "getComponent", "()Lorg/mkui/component/CPComponent;", "ColorsDataFrame", "mkui-molap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCPCustomColorMapEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPCustomColorMapEditor.kt\norg/mkui/colormap/editor/CPCustomColorMapEditor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,271:1\n37#2,2:272\n*S KotlinDebug\n*F\n+ 1 CPCustomColorMapEditor.kt\norg/mkui/colormap/editor/CPCustomColorMapEditor\n*L\n69#1:272,2\n*E\n"})
public final class CPCustomColorMapEditor
extends AbstractCustomColorMapEditor
implements CPComponentProvider {
    @NotNull
    private final CPFactory factory;
    @NotNull
    private final ColorMapFactory colorMapFactory;
    @NotNull
    private final MutableSingleSelection<CustomPalette.Mode> mode;
    @NotNull
    private final CPVerticalFlowPanel mainPanel;
    @NotNull
    private final CPRadioButtons<CustomPalette.Mode> bandsRampsRadioButtons;
    @NotNull
    private final CPColorPicker underflowColor;
    @NotNull
    private final CPColorPicker overflowColor;
    @NotNull
    private final CPColorPicker missingValueColor;
    @NotNull
    private final Table<Integer, String, Object> table;
    @NotNull
    private final CPOverlayPanel colorMapPreviewContainer;
    @NotNull
    private final CPSlider brightnessSlider;
    @NotNull
    private final CPSlider saturationSlider;
    @NotNull
    private final CPCheckBox overColorCheckBox;
    @NotNull
    private final CPCheckBox underColorCheckBox;
    public static final int $stable = 8;

    public CPCustomColorMapEditor(@NotNull CPFactory factory, @NotNull ColorMapFactory colorMapFactory, @NotNull TableFactory tableFactory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)colorMapFactory, (String)"colorMapFactory");
        Intrinsics.checkNotNullParameter((Object)tableFactory, (String)"tableFactory");
        this.factory = factory;
        this.colorMapFactory = colorMapFactory;
        this.mode = (MutableSingleSelection)new SimpleSingleSelection(null);
        this.mainPanel = this.factory.createVerticalFlowPanel(new CPComponent[0]);
        CPFormPanel formPanel = this.factory.createFormPanel();
        Collection $this$toTypedArray$iv = (Collection)CustomPalette.Mode.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.bandsRampsRadioButtons = this.factory.createRadioButtons((Object[])thisCollection$iv.toArray(new CustomPalette.Mode[0]));
        this.underflowColor = this.factory.createColorPicker();
        this.overflowColor = this.factory.createColorPicker();
        this.missingValueColor = this.factory.createColorPicker();
        this.table = tableFactory.createTable();
        this.table.setColumnResizePolicy(Table.ColumnResizePolicy.Constrained);
        this.table.setPrefHeight(200.0);
        this.colorMapPreviewContainer = this.factory.createOverlayPanel();
        this.brightnessSlider = this.factory.createSlider();
        this.brightnessSlider.setMinimum(-150.0);
        this.brightnessSlider.setMaximum(150.0);
        this.saturationSlider = this.factory.createSlider();
        this.saturationSlider.setMinimum(-150.0);
        this.saturationSlider.setMaximum(150.0);
        this.overColorCheckBox = this.factory.createCheckBox("Overflow Color:", null);
        this.underColorCheckBox = this.factory.createCheckBox("Underflow Color:", null);
        this.mainPanel.add((CPComponent)this.table);
        formPanel.add(null, (CPComponent)this.bandsRampsRadioButtons);
        formPanel.add((CPComponent)this.factory.createLabel("Brightness:"), (CPComponent)this.brightnessSlider);
        formPanel.add((CPComponent)this.factory.createLabel("Saturation:"), (CPComponent)this.saturationSlider);
        formPanel.add((CPComponent)this.overColorCheckBox, (CPComponent)this.overflowColor);
        formPanel.add((CPComponent)this.underColorCheckBox, (CPComponent)this.underflowColor);
        formPanel.add((CPComponent)this.factory.createLabel("Missing Values Color:"), (CPComponent)this.missingValueColor);
        this.mainPanel.add((CPComponent)formPanel);
    }

    public void setColorMap(@NotNull MutableColorMap colorMap, @NotNull KClass<?> type, @NotNull Number min, @NotNull Number max, @Nullable CPFormat<Object> format) {
        Intrinsics.checkNotNullParameter((Object)colorMap, (String)"colorMap");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.setColorMap(colorMap);
        this.setMin(min);
        this.setMax(max);
        MutablePalette mutablePalette = colorMap.getPalette();
        Intrinsics.checkNotNull((Object)mutablePalette, (String)"null cannot be cast to non-null type org.mkui.palette.CustomPalette");
        MutableDataFrame dataFrame = (MutableDataFrame)new ColorsDataFrame((CustomPalette)mutablePalette, type, min, max);
        SimpleVisualObjects visualObjects = new SimpleVisualObjects((DataFrame)dataFrame);
        SimpleVisual visual = new SimpleVisual(visualObjects, new SimpleColorMapping(this.colorMapFactory, (DataFrame)dataFrame));
        this.table.setModel((DataFrame<Integer, String, Object>)((DataFrame)dataFrame), (Visual<Integer, String>)((Visual)visual));
        this.table.setCellRenderer("Color", new ColorCellRenderer(this.factory, (MutableDataFrame<Integer, String, Object>)dataFrame));
        this.table.setEditable(true);
        this.table.setCellEditor("Threshold", new Table.CellEditor<Integer, String, Object>(){
            private final CPFormat<Object> decimalFormat;
            {
                this.decimalFormat = FormatFactory.Companion.getInstance().createDecimalFormat();
            }

            public final CPFormat<Object> getDecimalFormat() {
                return this.decimalFormat;
            }

            public boolean isEditable(int row, String column, Object value) {
                Intrinsics.checkNotNullParameter((Object)column, (String)"column");
                return true;
            }

            public CPFormat<Object> getFormat() {
                return this.decimalFormat;
            }
        });
        MutablePalette mutablePalette2 = colorMap.getPalette();
        Intrinsics.checkNotNull((Object)mutablePalette2, (String)"null cannot be cast to non-null type org.mkui.palette.CustomPalette");
        this.bandsRampsRadioButtons.setSelection((MutableSingleSelection)new PropertySingleSelection(((CustomPalette)mutablePalette2).modeProperty()));
        this.underflowColor.setProperty(colorMap.getUnderColorProperty());
        this.missingValueColor.setProperty(colorMap.getNullColorProperty());
        this.overflowColor.setProperty(colorMap.getOverColorProperty());
        this.underColorCheckBox.setProperty(colorMap.getUnderColorSetProperty());
        this.overColorCheckBox.setProperty(colorMap.getOverColorSetProperty());
        this.brightnessSlider.setProperty(colorMap.getBrightnessProperty());
        this.saturationSlider.setProperty(colorMap.getSaturationProperty());
    }

    @NotNull
    public CPComponent getComponent() {
        return (CPComponent)this.mainPanel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0018\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J!\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u0003\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010'J\u0016\u0010-\u001a\u00020.2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010\u0017\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b*\u0004\b\u0018\u0010\u0019R\u0014\u0010(\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0014\u00104\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u00067"}, d2={"Lorg/mkui/colormap/editor/CPCustomColorMapEditor$ColorsDataFrame;", "Lorg/molap/dataframe/AbstractMutableDataFrame;", "", "", "", "palette", "Lorg/mkui/palette/CustomPalette;", "valueType", "Lkotlin/reflect/KClass;", "min", "", "max", "<init>", "(Lorg/mkui/palette/CustomPalette;Lkotlin/reflect/KClass;Ljava/lang/Number;Ljava/lang/Number;)V", "columnIndex", "Lorg/molap/index/DefaultUniqueIndex;", "getColumnIndex", "()Lorg/molap/index/DefaultUniqueIndex;", "rowIndexDelegate", "Lcom/macrofocus/common/delegate/Delegate;", "Lorg/molap/index/IntegerRangeUniqueIndex;", "getRowIndexDelegate", "()Lcom/macrofocus/common/delegate/Delegate;", "rowIndex", "getRowIndex$delegate", "(Lorg/mkui/colormap/editor/CPCustomColorMapEditor$ColorsDataFrame;)Ljava/lang/Object;", "getRowIndex", "()Lorg/molap/index/IntegerRangeUniqueIndex;", "setValueAt", "", "row", "column", "value", "getRowClass", "getColumnClass", "getValueAt", "getRow", "Lorg/molap/series/Series;", "integer", "(Ljava/lang/Integer;)Lorg/molap/series/Series;", "rowCount", "getRowCount", "()I", "columnCount", "getColumnCount", "isCellEditable", "", "getAbsolute", "", "fraction", "getEntry", "Lorg/mkui/palette/InterpolatedPalette$Entry;", "interpolatedPalette", "getInterpolatedPalette", "()Lorg/mkui/palette/CustomPalette;", "mkui-molap"})
    @SourceDebugExtension(value={"SMAP\nCPCustomColorMapEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPCustomColorMapEditor.kt\norg/mkui/colormap/editor/CPCustomColorMapEditor$ColorsDataFrame\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,271:1\n37#2,2:272\n*S KotlinDebug\n*F\n+ 1 CPCustomColorMapEditor.kt\norg/mkui/colormap/editor/CPCustomColorMapEditor$ColorsDataFrame\n*L\n261#1:272,2\n*E\n"})
    private static final class ColorsDataFrame
    extends AbstractMutableDataFrame<Integer, String, Object> {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final CustomPalette palette;
        @NotNull
        private final KClass<?> valueType;
        @NotNull
        private final Number min;
        @NotNull
        private final Number max;
        @NotNull
        private final DefaultUniqueIndex<String> columnIndex;
        @NotNull
        private final Delegate<IntegerRangeUniqueIndex> rowIndexDelegate;

        public ColorsDataFrame(@NotNull CustomPalette palette, @NotNull KClass<?> valueType, @NotNull Number min, @NotNull Number max) {
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            this.palette = palette;
            this.valueType = valueType;
            this.min = min;
            this.max = max;
            Object[] objectArray = new String[]{"Threshold", "Color"};
            this.columnIndex = new DefaultUniqueIndex(objectArray);
            this.rowIndexDelegate = MutableLazyKt.mutableLazy(() -> ColorsDataFrame.rowIndexDelegate$lambda$0(this));
            this.palette.addPaletteListener(new PaletteListener(){

                public void paletteChanged(PaletteEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.getRowIndexDelegate().forget();
                    this.notifyDataFrameChanged(new DataFrameEvent(null, null, true));
                }
            });
        }

        @NotNull
        public DefaultUniqueIndex<String> getColumnIndex() {
            return this.columnIndex;
        }

        @NotNull
        public final Delegate<IntegerRangeUniqueIndex> getRowIndexDelegate() {
            return this.rowIndexDelegate;
        }

        @NotNull
        public IntegerRangeUniqueIndex getRowIndex() {
            return (IntegerRangeUniqueIndex)this.rowIndexDelegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private static Object getRowIndex$delegate(ColorsDataFrame colorsDataFrame) {
            return colorsDataFrame.rowIndexDelegate;
        }

        public void setValueAt(int row, @NotNull String column, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            int rowIndex = this.getRowIndex().getAddress(row);
            int columnIndex = this.getColumnIndex().getAddress((Object)column);
            switch (columnIndex) {
                case 0: {
                    InterpolatedPalette.Entry entry = this.getEntry(rowIndex);
                    this.getInterpolatedPalette().setColor(entry.getFraction(), null);
                    if (value == null || !(value instanceof Number) && !CPHelper.Companion.getInstance().isTemporalValue(value)) break;
                    double value2 = CPHelper.Companion.getInstance().isTemporalValue(value) ? CPHelper.Companion.getInstance().doubleTemporalValue(value) : ((Number)value).doubleValue();
                    double fraction = (value2 - this.min.doubleValue()) / (this.max.doubleValue() - this.min.doubleValue());
                    if (!MathKt.isNaN((double)entry.getFraction())) {
                        this.getInterpolatedPalette().setColor(fraction, entry.getColor());
                        break;
                    }
                    MkColor newColor = this.getInterpolatedPalette().getColor(value2);
                    if (newColor != null) {
                        this.getInterpolatedPalette().setColor(fraction, newColor);
                        break;
                    }
                    this.getInterpolatedPalette().setColor(fraction, entry.getColor());
                    break;
                }
                case 1: {
                    CustomPalette customPalette = this.getInterpolatedPalette();
                    double d = this.getEntry(rowIndex).getFraction();
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.mkui.color.MkColor");
                    customPalette.setColor(d, (MkColor)value);
                }
            }
        }

        @NotNull
        public KClass<? extends Object> getRowClass(int row) {
            return Reflection.getOrCreateKotlinClass(Object.class);
        }

        @NotNull
        public KClass<? extends Object> getColumnClass(@NotNull String column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            return switch (this.getColumnIndex().getAddress((Object)column)) {
                case 0 -> this.valueType;
                case 1 -> Reflection.getOrCreateKotlinClass(MkColor.class);
                default -> Reflection.getOrCreateKotlinClass(Object.class);
            };
        }

        @Nullable
        public Object getValueAt(int row, @NotNull String column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            int rowIndex = this.getRowIndex().getAddress(row);
            switch (this.getColumnIndex().getAddress((Object)column)) {
                case 0: {
                    double fraction = this.getEntry(rowIndex).getFraction();
                    return !MathKt.isNaN((double)fraction) ? Double.valueOf(this.getAbsolute(fraction)) : null;
                }
                case 1: {
                    if (this.getInterpolatedPalette().getMode() == CustomPalette.Mode.Bands && rowIndex == this.getInterpolatedPalette().getEntries().size() - 1) {
                        return new CustomPalette.Entry(Double.NaN, MkColorKt.colorOf((int)255, (int)255, (int)255, (int)0));
                    }
                    return this.getEntry(rowIndex).getColor();
                }
            }
            return null;
        }

        @Nullable
        public final Series<String, ?> getRow(@Nullable Integer integer) {
            return null;
        }

        public int getRowCount() {
            return this.getInterpolatedPalette().getEntries().size() + 1;
        }

        public int getColumnCount() {
            return 2;
        }

        public final boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1 && this.getInterpolatedPalette().getMode() == CustomPalette.Mode.Bands && rowIndex == this.getInterpolatedPalette().getEntries().size() - 1) {
                return false;
            }
            return rowIndex < this.getInterpolatedPalette().getEntries().size() || columnIndex == 0;
        }

        private final double getAbsolute(double fraction) {
            return this.min != null && this.max != null ? this.min.doubleValue() + fraction * (this.max.doubleValue() - this.min.doubleValue()) : fraction;
        }

        private final InterpolatedPalette.Entry getEntry(int rowIndex) {
            InterpolatedPalette.Entry entry;
            if (rowIndex < this.getInterpolatedPalette().getEntries().size()) {
                Collection $this$toTypedArray$iv = this.getInterpolatedPalette().getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                CustomPalette.Entry entry2 = thisCollection$iv.toArray(new CustomPalette.Entry[0])[rowIndex];
                Intrinsics.checkNotNull((Object)entry2, (String)"null cannot be cast to non-null type org.mkui.palette.InterpolatedPalette.Entry");
                entry = (InterpolatedPalette.Entry)entry2;
            } else {
                entry = new InterpolatedPalette.Entry(Double.NaN, MkColorKt.colorOf((int)255, (int)255, (int)255, (int)0));
            }
            return entry;
        }

        private final CustomPalette getInterpolatedPalette() {
            return this.palette;
        }

        private static final IntegerRangeUniqueIndex rowIndexDelegate$lambda$0(ColorsDataFrame this$0) {
            return new IntegerRangeUniqueIndex(0, this$0.getRowCount() - 1);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ColorsDataFrame.class, "rowIndex", "getRowIndex()Lorg/molap/index/IntegerRangeUniqueIndex;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

