/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.tooltip;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import io.nacular.doodle.drawing.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Point;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.Insets;
import org.mkui.tooltip.Tooltip;
import org.molap.dataframe.DataFrame;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B1\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0016J#\u0010(\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010(\u001a\u00020)\u00a2\u0006\u0002\u0010*J\u0018\u0010(\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020'2\u0006\u0010!\u001a\u00020\"J\u0013\u0010.\u001a\u00020,2\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/R\u0015\u0010\u000b\u001a\u00060\fj\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\fj\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0019X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00060"}, d2={"Lcom/macrofocus/tooltip/DataFrameTooltip;", "Row", "Column", "Value", "Lorg/mkui/tooltip/Tooltip;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "row", "desiredLocation", "Lorg/mkui/geom/Point;", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Lorg/mkui/geom/Point;)V", "backgroundColor", "Lio/nacular/doodle/drawing/Color;", "Lorg/mkui/color/MkColor;", "getBackgroundColor", "()Lio/nacular/doodle/drawing/Color;", "borderColor", "getBorderColor", "getDesiredLocation", "()Lorg/mkui/geom/Point;", "insets", "Lorg/mkui/graphics/Insets;", "getInsets", "()Lorg/mkui/graphics/Insets;", "minimumHeight", "", "getMinimumHeight", "()I", "preferredWidth", "getPreferredWidth", "getRow", "()Ljava/lang/Object;", "Ljava/lang/Object;", "size", "Lcom/macrofocus/common/geom/Dimension;", "getSize", "()Lcom/macrofocus/common/geom/Dimension;", "computePreferredSize", "graphics", "Lorg/mkui/graphics/IGraphics;", "paint", "", "(Lorg/mkui/graphics/IGraphics;Ljava/lang/Object;Z)Lcom/macrofocus/common/geom/Dimension;", "paintBackground", "", "g", "preferredSize", "(Ljava/lang/Object;)V", "mkui-molap"})
@StabilityInferred(parameters=0)
public final class DataFrameTooltip<Row, Column, Value>
implements Tooltip<Row> {
    private final Row row;
    @Nullable
    private final Point desiredLocation;
    @NotNull
    private final Dimension size;
    @NotNull
    private final Insets insets;
    private final int preferredWidth;
    private final int minimumHeight;
    @NotNull
    private final Color backgroundColor;
    @NotNull
    private final Color borderColor;
    public static final int $stable = 8;

    public DataFrameTooltip(@NotNull DataFrame<Row, Column, Value> dataFrame, Row row, @Nullable Point desiredLocation) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        this.row = row;
        this.desiredLocation = desiredLocation;
        this.size = new Dimension(0, 0);
        this.insets = new Insets(2, 2, 2, 2);
        this.preferredWidth = 230;
        this.minimumHeight = 40;
        this.backgroundColor = MkColorKt.colorOf-bW95L_I((byte)-24, (byte)-24, (byte)-24, (byte)-56);
        this.borderColor = MkColorKt.colorOf-bW95L_I((byte)0, (byte)0, (byte)0, (byte)-16);
    }

    public final Row getRow() {
        return this.row;
    }

    @Nullable
    public Point getDesiredLocation() {
        return this.desiredLocation;
    }

    @NotNull
    public final Dimension getSize() {
        return this.size;
    }

    @NotNull
    public final Insets getInsets() {
        return this.insets;
    }

    public final int getPreferredWidth() {
        return this.preferredWidth;
    }

    public final int getMinimumHeight() {
        return this.minimumHeight;
    }

    @NotNull
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @NotNull
    public final Color getBorderColor() {
        return this.borderColor;
    }

    @NotNull
    public Dimension computePreferredSize(@NotNull IGraphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        return this.paint(graphics, this.row, false);
    }

    @NotNull
    public Dimension paint(@NotNull IGraphics graphics, @NotNull Dimension size) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        int x = this.insets.getLeft();
        int y = this.insets.getTop();
        Dimension drawableSize = new Dimension(size.getIwidth() - this.insets.getLeft() - this.insets.getRight(), size.getIheight() - this.insets.getTop() - this.insets.getBottom());
        this.paintBackground(graphics, size);
        return drawableSize;
    }

    @NotNull
    public final Dimension paint(@NotNull IGraphics graphics, Row row, boolean paint) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        return new Dimension(this.preferredWidth, this.minimumHeight);
    }

    public final void paintBackground(@NotNull IGraphics g, @NotNull Dimension size) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        g.setColor(this.backgroundColor);
        int x = this.insets.getLeft();
        int y = this.insets.getTop();
        g.fillRectangle(x, y, size.getIwidth(), size.getIheight());
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            float borderThickness = this.insets.getLeft();
            g.setLineWidth((double)borderThickness);
            double halfThickness = borderThickness / (float)2;
            g.drawRectange((int)halfThickness, (int)halfThickness, size.getIwidth(), size.getIheight());
        }
    }

    public final void preferredSize(Row row) {
    }
}

