/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.colormap.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.adapter.IntervalProperty;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.PropertySingleSelection;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.colormap.ColorMapFactory;
import org.mkui.colormap.MutableColorMap;
import org.mkui.colormap.editor.AbstractPredefinedColorMapEditor;
import org.mkui.colormap.editor.CPPredefinedColorMapEditor;
import org.mkui.component.CPComponent;
import org.mkui.component.CPComponentProvider;
import org.mkui.component.CPFactory;
import org.mkui.component.button.CPCheckBox;
import org.mkui.component.button.CPComboBox;
import org.mkui.component.button.CPSplitMenuButton;
import org.mkui.component.input.CPColorPicker;
import org.mkui.component.input.CPSlider;
import org.mkui.component.input.CPSpinner;
import org.mkui.component.panel.CPFormPanel;
import org.mkui.component.panel.CPOverlayPanel;
import org.mkui.component.panel.CPScrollPane;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IDrawingListener;
import org.mkui.graphics.IGraphics;
import org.mkui.palette.CustomPalette;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteFactory;
import org.mkui.palette.PaletteType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ6\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-2\u0010\u0010/\u001a\f\u0012\u0006\u0012\u0004\u0018\u000101\u0018\u000100H\u0016J#\u00102\u001a\u00020)2\u0016\u00103\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010504\"\u0004\u0018\u000105\u00a2\u0006\u0002\u00106R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lorg/mkui/colormap/editor/CPPredefinedColorMapEditor;", "Lorg/mkui/component/CPComponentProvider;", "Lorg/mkui/colormap/editor/AbstractPredefinedColorMapEditor;", "factory", "Lorg/mkui/component/CPFactory;", "colorMapFactory", "Lorg/mkui/colormap/ColorMapFactory;", "<init>", "(Lorg/mkui/component/CPFactory;Lorg/mkui/colormap/ColorMapFactory;)V", "mainPanel", "Lorg/mkui/component/panel/CPFormPanel;", "setToFullRangeButton", "Lorg/mkui/component/button/CPSplitMenuButton;", "maximumSpinner", "Lorg/mkui/component/input/CPSpinner;", "", "minimumSpinner", "underflowColor", "Lorg/mkui/component/input/CPColorPicker;", "missingValueColor", "overflowColor", "paletteComboBox", "Lorg/mkui/component/button/CPComboBox;", "Lorg/mkui/palette/MutablePalette;", "colorMapPreviewContainer", "Lorg/mkui/component/panel/CPOverlayPanel;", "numberOfStepsCheckBox", "Lorg/mkui/component/button/CPCheckBox;", "invertedCheckBox", "numberOfStepsSpinner", "", "underColorCheckBox", "overColorCheckBox", "brightnessSlider", "Lorg/mkui/component/input/CPSlider;", "saturationSlider", "minMaxPanel", "optionsPanel", "optionsScrollPane", "Lorg/mkui/component/panel/CPScrollPane;", "setColorMap", "", "colorMap", "Lorg/mkui/colormap/MutableColorMap;", "min", "", "max", "format", "Lcom/macrofocus/common/format/CPFormat;", "", "setStyleClass", "styleClasses", "", "", "([Ljava/lang/String;)V", "component", "Lorg/mkui/component/CPComponent;", "getComponent", "()Lorg/mkui/component/CPComponent;", "mkui-molap"})
@StabilityInferred(parameters=0)
public final class CPPredefinedColorMapEditor
extends AbstractPredefinedColorMapEditor
implements CPComponentProvider {
    @NotNull
    private final CPFactory factory;
    @NotNull
    private final ColorMapFactory colorMapFactory;
    @NotNull
    private final CPFormPanel mainPanel;
    @NotNull
    private final CPSplitMenuButton setToFullRangeButton;
    @NotNull
    private final CPSpinner<Double> maximumSpinner;
    @NotNull
    private final CPSpinner<Double> minimumSpinner;
    @NotNull
    private final CPColorPicker underflowColor;
    @NotNull
    private final CPColorPicker missingValueColor;
    @NotNull
    private final CPColorPicker overflowColor;
    @NotNull
    private final CPComboBox<MutablePalette> paletteComboBox;
    @NotNull
    private final CPOverlayPanel colorMapPreviewContainer;
    @NotNull
    private final CPCheckBox numberOfStepsCheckBox;
    @NotNull
    private final CPCheckBox invertedCheckBox;
    @NotNull
    private final CPSpinner<Integer> numberOfStepsSpinner;
    @NotNull
    private final CPCheckBox underColorCheckBox;
    @NotNull
    private final CPCheckBox overColorCheckBox;
    @NotNull
    private final CPSlider brightnessSlider;
    @NotNull
    private final CPSlider saturationSlider;
    @NotNull
    private final CPFormPanel minMaxPanel;
    @Nullable
    private final CPFormPanel optionsPanel;
    @Nullable
    private final CPScrollPane optionsScrollPane;
    public static final int $stable = 8;

    public CPPredefinedColorMapEditor(@NotNull CPFactory factory, @NotNull ColorMapFactory colorMapFactory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)colorMapFactory, (String)"colorMapFactory");
        this.factory = factory;
        this.colorMapFactory = colorMapFactory;
        this.mainPanel = this.factory.createFormPanel();
        this.setToFullRangeButton = this.factory.createSplitMenuButton();
        this.maximumSpinner = this.factory.createDoubleSpinner();
        this.maximumSpinner.setStyleClass("spinner", "maximumSpinner");
        this.minimumSpinner = this.factory.createDoubleSpinner();
        this.setToFullRangeButton.setStyleClass("setToFullRangeButton");
        this.setToFullRangeButton.setDefaultCommand((UICommand)new AbstractUICommand(){

            public void execute(Object source) {
                Double d;
                Double d2;
                CPSpinner cPSpinner = minimumSpinner;
                if (this.getMin() != null) {
                    Number number = this.getMin();
                    Intrinsics.checkNotNull((Object)number);
                    d2 = number.doubleValue();
                } else {
                    d2 = null;
                }
                cPSpinner.setValue(d2);
                CPSpinner cPSpinner2 = maximumSpinner;
                if (this.getMax() != null) {
                    Number number = this.getMax();
                    Intrinsics.checkNotNull((Object)number);
                    d = number.doubleValue();
                } else {
                    d = null;
                }
                cPSpinner2.setValue(d);
            }
        });
        this.setToFullRangeButton.addCommand((UICommand)new AbstractUICommand(){

            public void execute(Object source) {
                Double d;
                Double d2;
                CPSpinner cPSpinner = minimumSpinner;
                if (this.getMin() != null) {
                    Number number = this.getMin();
                    Intrinsics.checkNotNull((Object)number);
                    d2 = number.doubleValue();
                } else {
                    d2 = null;
                }
                cPSpinner.setValue(d2);
                CPSpinner cPSpinner2 = maximumSpinner;
                if (this.getMax() != null) {
                    Number number = this.getMax();
                    Intrinsics.checkNotNull((Object)number);
                    d = number.doubleValue();
                } else {
                    d = null;
                }
                cPSpinner2.setValue(d);
            }
        });
        this.setToFullRangeButton.addCommand((UICommand)new AbstractUICommand(){

            public void execute(Object source) {
                Number number = this.getMin();
                Intrinsics.checkNotNull((Object)number);
                double d = Math.signum(number.doubleValue());
                Number number2 = this.getMin();
                Intrinsics.checkNotNull((Object)number2);
                double s = d * Math.pow(10.0, Math.floor(Math.log10(Math.abs(number2.doubleValue()))));
                minimumSpinner.setValue((Object)s);
                Number number3 = this.getMax();
                Intrinsics.checkNotNull((Object)number3);
                double d2 = Math.signum(number3.doubleValue());
                Number number4 = this.getMax();
                Intrinsics.checkNotNull((Object)number4);
                double e = d2 * Math.pow(10.0, Math.ceil(Math.log10(Math.abs(number4.doubleValue()))));
                maximumSpinner.setValue((Object)e);
            }
        });
        this.setToFullRangeButton.addCommand((UICommand)new AbstractUICommand(){

            /*
             * Enabled aggressive block sorting
             */
            public void execute(Object source) {
                Double d;
                Number number = this.getMin();
                Intrinsics.checkNotNull((Object)number);
                if (number.doubleValue() < 0.0) {
                    Number number2 = this.getMin();
                    Intrinsics.checkNotNull((Object)number2);
                    if (number2.doubleValue() > 0.0) {
                        double d2 = 0.0;
                        Number number3 = this.getMin();
                        Intrinsics.checkNotNull((Object)number3);
                        double diffMin = d2 - number3.doubleValue();
                        Number number4 = this.getMax();
                        Intrinsics.checkNotNull((Object)number4);
                        double diffMax = number4.doubleValue();
                        double maxDiff = Math.max(diffMin, diffMax);
                        minimumSpinner.setValue((Object)(0.0 - maxDiff));
                        maximumSpinner.setValue((Object)maxDiff);
                        return;
                    }
                }
                CPSpinner cPSpinner = minimumSpinner;
                Number number5 = this.getMax();
                Intrinsics.checkNotNull((Object)number5);
                cPSpinner.setValue((Object)(-number5.doubleValue()));
                CPSpinner cPSpinner2 = maximumSpinner;
                if (this.getMax() != null) {
                    Number number6 = this.getMax();
                    Intrinsics.checkNotNull((Object)number6);
                    d = number6.doubleValue();
                } else {
                    d = null;
                }
                cPSpinner2.setValue(d);
            }
        });
        this.underflowColor = this.factory.createColorPicker();
        this.missingValueColor = this.factory.createColorPicker();
        this.overflowColor = this.factory.createColorPicker();
        this.paletteComboBox = CPFactory.DefaultImpls.createComboBox$default((CPFactory)this.factory, null, null, (int)3, null);
        this.paletteComboBox.setRenderer((CPComboBox.ItemRenderer)new CPComboBox.ItemRenderer<MutablePalette>(){

            public CPComponent render(MutablePalette item) {
                if (item != null) {
                    CPCanvas canvas = factory.createCanvas();
                    canvas.addLayer(new IDrawing(item){
                        private final CustomPalette.Mode mode;
                        final /* synthetic */ MutablePalette $item;
                        {
                            this.$item = $item;
                            this.mode = CustomPalette.Mode.Ramps;
                        }

                        public boolean isActive() {
                            return true;
                        }

                        public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
                            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                            Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                            boolean insetTop = false;
                            int insetLeft = 0;
                            boolean insetBottom = false;
                            boolean insetRight = false;
                            switch (render.WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
                                case 1: {
                                    for (int i = 0; i < this.$item.getColorCount(); ++i) {
                                        Color color = this.$item.getColorAt(i);
                                        int x1 = insetLeft + (int)(width * (double)i / (Double)this.$item.getColorCount());
                                        int x2 = insetLeft + (int)(width * (double)(i + 1) / (Double)this.$item.getColorCount());
                                        g.setColor(color);
                                        g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double((double)x1, (double)insetTop, (double)(x2 - x1) + 1.0, height - (double)insetTop - (double)insetBottom));
                                    }
                                    break;
                                }
                                case 2: {
                                    int colorCount = 256;
                                    for (int i = 0; i < colorCount; ++i) {
                                        Color color = this.$item.getColor((double)i / ((double)colorCount - 1.0));
                                        int x1 = insetLeft + (int)(width * (double)i / (double)colorCount);
                                        int x2 = insetLeft + (int)(width * (double)(i + 1) / (double)colorCount);
                                        Color color2 = color;
                                        Intrinsics.checkNotNull((Object)color2);
                                        g.setColor(color2);
                                        g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double((double)x1, (double)insetTop, (double)(x2 - x1) + 1.0, height - (double)insetTop - (double)insetBottom));
                                    }
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                        }

                        public void addIDrawingListener(IDrawingListener listener2) {
                            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
                        }

                        public void removeIDrawingListener(IDrawingListener listener2) {
                            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
                        }
                    });
                    return (CPComponent)canvas;
                }
                return (CPComponent)factory.createLabel("");
            }
        });
        this.colorMapPreviewContainer = this.factory.createOverlayPanel();
        this.numberOfStepsCheckBox = this.factory.createCheckBox("Number of Steps:", null);
        this.invertedCheckBox = this.factory.createCheckBox("Inverted", null);
        this.numberOfStepsSpinner = this.factory.createIntegerSpinner();
        this.underColorCheckBox = this.factory.createCheckBox("Underflow Color:", null);
        this.overColorCheckBox = this.factory.createCheckBox("Overflow Color:", null);
        this.brightnessSlider = this.factory.createSlider();
        this.brightnessSlider.setMinimum(-150.0);
        this.brightnessSlider.setMaximum(150.0);
        this.saturationSlider = this.factory.createSlider();
        this.saturationSlider.setMinimum(-150.0);
        this.saturationSlider.setMaximum(150.0);
        this.minMaxPanel = this.factory.createFormPanel();
        this.mainPanel.add((CPComponent)this.factory.createLabel("Palette:"), (CPComponent)this.paletteComboBox);
        this.mainPanel.add((CPComponent)this.factory.createLabel("Maximum:"), (CPComponent)this.maximumSpinner);
        this.mainPanel.add((CPComponent)this.factory.createLabel("Minimum:"), (CPComponent)this.minimumSpinner);
        this.mainPanel.add(null, (CPComponent)this.setToFullRangeButton);
        this.mainPanel.add((CPComponent)this.numberOfStepsCheckBox, (CPComponent)this.numberOfStepsSpinner);
        this.mainPanel.add((CPComponent)this.invertedCheckBox, null);
        this.mainPanel.add((CPComponent)this.factory.createLabel("Brightness:"), (CPComponent)this.brightnessSlider);
        this.mainPanel.add((CPComponent)this.factory.createLabel("Saturation:"), (CPComponent)this.saturationSlider);
        this.mainPanel.add((CPComponent)this.overColorCheckBox, (CPComponent)this.overflowColor);
        this.mainPanel.add((CPComponent)this.underColorCheckBox, (CPComponent)this.underflowColor);
        this.mainPanel.add((CPComponent)this.factory.createLabel("Missing Values Color:"), (CPComponent)this.missingValueColor);
    }

    public void setColorMap(@NotNull MutableColorMap colorMap, @Nullable Number min, @Nullable Number max, @Nullable CPFormat<Object> format) {
        Intrinsics.checkNotNullParameter((Object)colorMap, (String)"colorMap");
        this.setColorMap(colorMap);
        this.setMin(min);
        this.setMax(max);
        this.setFormat(format);
        MutableInterval mutableInterval = colorMap.getInterval();
        Intrinsics.checkNotNull((Object)mutableInterval);
        this.maximumSpinner.setProperty((MutableProperty)new IntervalProperty(mutableInterval, IntervalProperty.Value.End));
        this.maximumSpinner.setFormat(format);
        MutableInterval mutableInterval2 = colorMap.getInterval();
        Intrinsics.checkNotNull((Object)mutableInterval2);
        this.minimumSpinner.setProperty((MutableProperty)new IntervalProperty(mutableInterval2, IntervalProperty.Value.Start));
        this.minimumSpinner.setFormat(format);
        this.underflowColor.setProperty(colorMap.getUnderColorProperty());
        this.missingValueColor.setProperty(colorMap.getNullColorProperty());
        this.overflowColor.setProperty(colorMap.getOverColorProperty());
        List palettes = new ArrayList();
        for (PaletteFactory.Entry entry : this.colorMapFactory.getPaletteFactory().getEntries()) {
            if (entry.getType() == PaletteType.QUALITATIVE) continue;
            palettes.add(entry.getPalette());
        }
        this.paletteComboBox.setModel((MutableSingleSelection)new PropertySingleSelection(colorMap.getPaletteProperty()), (Iterable)palettes);
        this.numberOfStepsCheckBox.setProperty(colorMap.getColorCountSetProperty());
        MutableProperty mutableProperty = colorMap.getColorCountProperty();
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Int?>");
        this.numberOfStepsSpinner.setProperty(mutableProperty);
        this.invertedCheckBox.setProperty(colorMap.isInvertedProperty());
        this.underColorCheckBox.setProperty(colorMap.getUnderColorSetProperty());
        this.overColorCheckBox.setProperty(colorMap.getOverColorSetProperty());
        this.brightnessSlider.setProperty(colorMap.getBrightnessProperty());
        this.saturationSlider.setProperty(colorMap.getSaturationProperty());
    }

    public final void setStyleClass(String ... styleClasses) {
        Intrinsics.checkNotNullParameter((Object)styleClasses, (String)"styleClasses");
    }

    @NotNull
    public CPComponent getComponent() {
        return (CPComponent)this.mainPanel;
    }

    @NotNull
    public JComponent getNativeComponent() {
        return CPComponentProvider.DefaultImpls.getNativeComponent((CPComponentProvider)this);
    }
}

