/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.helper;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0007J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\t\u001a\u0004\u0018\u00010\u0010J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010J\u0016\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0010J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010%\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0017\u00a8\u0006&"}, d2={"Lorg/mkui/helper/ColorHelper;", "", "<init>", "()V", "intMult", "", "a", "b", "Inva", "c", "intPrelerp", "dest", "src", "alpha", "intLerp", "desaturateColor", "Ljava/awt/Color;", "color", "saturationMutliplier", "", "brightnessMultiplier", "darker", "factor", "", "brighter", "getHTMLColor", "", "parseHTMLColor", "lum", "toGray", "compatible", "", "diff", "c1", "c2", "luminance", "brightness", "replaceBrightness", "mkui-molap"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nColorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorHelper.kt\norg/mkui/helper/ColorHelper\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,174:1\n108#2:175\n80#2,22:176\n*S KotlinDebug\n*F\n+ 1 ColorHelper.kt\norg/mkui/helper/ColorHelper\n*L\n111#1:175\n111#1:176,22\n*E\n"})
public final class ColorHelper {
    @NotNull
    public static final ColorHelper INSTANCE = new ColorHelper();
    public static final int $stable;

    private ColorHelper() {
    }

    public final int intMult(int a, int b) {
        return a * b / 255;
    }

    public final int Inva(int a, int c) {
        return (0xFF & ~a) * c / 255;
    }

    public final int intPrelerp(int dest, int src, int alpha) {
        return dest + src - this.intMult(alpha, dest);
    }

    public final int intLerp(int dest, int src, int alpha) {
        return dest + this.intMult(alpha, dest - src);
    }

    @JvmOverloads
    @NotNull
    public final Color desaturateColor(@NotNull Color color, float saturationMutliplier, float brightnessMultiplier) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (hsb[1] <= 0.0f) {
            hsb[2] = hsb[2] + brightnessMultiplier * (1.0f - hsb[2]);
        } else {
            hsb[1] = hsb[1] * saturationMutliplier;
        }
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }

    public static /* synthetic */ Color desaturateColor$default(ColorHelper colorHelper, Color color, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.3f;
        }
        if ((n & 4) != 0) {
            f2 = 0.5f;
        }
        return colorHelper.desaturateColor(color, f, f2);
    }

    @NotNull
    public final Color darker(@NotNull Color color, double factor) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return new Color((int)Math.max((double)((int)((double)color.getRed() * factor)), 0.0), (int)Math.max((double)((int)((double)color.getGreen() * factor)), 0.0), (int)Math.max((double)((int)((double)color.getBlue() * factor)), 0.0), color.getAlpha());
    }

    @NotNull
    public final Color brighter(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int increment = 100;
        return new Color((int)Math.min((double)(r + increment), 255.0), (int)Math.min((double)(g + increment), 255.0), (int)Math.min((double)(b + increment), 255.0));
    }

    @NotNull
    public final Color brighter(@NotNull Color color, double factor) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color((int)Math.min((double)((int)((double)r / factor)), 255.0), (int)Math.min((double)((int)((double)g / factor)), 255.0), (int)Math.min((double)((int)((double)b / factor)), 255.0));
    }

    @NotNull
    public final String getHTMLColor(@Nullable Color c) {
        if (c != null) {
            String alpha = Integer.toHexString(c.getAlpha());
            Object red = Integer.toHexString(c.getRed());
            Object blu = Integer.toHexString(c.getBlue());
            Object gre = Integer.toHexString(c.getGreen());
            alpha = c.getAlpha() == 255 ? "" : (alpha.length() == 1 ? "0" + alpha : alpha);
            red = ((String)red).length() == 1 ? "0" + (String)red : red;
            blu = ((String)blu).length() == 1 ? "0" + (String)blu : blu;
            gre = ((String)gre).length() == 1 ? "0" + (String)gre : gre;
            return "#" + alpha + (String)red + (String)gre + (String)blu;
        }
        return "";
    }

    @Nullable
    public final Color parseHTMLColor(@Nullable String c) {
        String c2 = c;
        if (c2 != null) {
            String $this$trim$iv = c2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!Intrinsics.areEqual((Object)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (Object)"")) {
                if (StringsKt.startsWith$default((String)c2, (String)"#", (boolean)false, (int)2, null)) {
                    String string = c2.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    c2 = string;
                }
                boolean hasalpha = c2.length() > 6;
                Color color = new Color((int)Long.parseLong(c2, CharsKt.checkRadix((int)16)), hasalpha);
                return color;
            }
            return null;
        }
        return null;
    }

    public final double lum(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
    }

    @NotNull
    public final Color toGray(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int y = (int)Math.round(this.lum(color));
        Color gray = new Color(y, y, y);
        return gray;
    }

    public final boolean compatible(@NotNull Color a, @NotNull Color b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Math.abs(this.lum(a) - this.lum(b)) >= 128.0;
    }

    public final float diff(@NotNull Color c1, @NotNull Color c2) {
        Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
        int r = (int)Math.abs((double)(c1.getRed() - c2.getRed()));
        int g = (int)Math.abs((double)(c1.getGreen() - c2.getGreen()));
        int b = (int)Math.abs((double)(c1.getBlue() - c2.getBlue()));
        return (float)(Math.max((double)r, Math.max((double)g, (double)b)) / (double)255.0f);
    }

    public final float luminance(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return (0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b) / 255.0f;
    }

    public final float brightness(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return hsb[2];
    }

    @NotNull
    public final Color replaceBrightness(@NotNull Color color, double brightness) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color resultColor = Color.getHSBColor(hsb[0], hsb[1], (float)brightness);
        Intrinsics.checkNotNull((Object)resultColor);
        return resultColor;
    }

    @JvmOverloads
    @NotNull
    public final Color desaturateColor(@NotNull Color color, float saturationMutliplier) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return ColorHelper.desaturateColor$default(this, color, saturationMutliplier, 0.0f, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Color desaturateColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return ColorHelper.desaturateColor$default(this, color, 0.0f, 0.0f, 6, null);
    }
}

