/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.table;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.table.DataFrameTableModel;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004B!\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u000bH\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010$\u001a\u00020\u000bH\u0016J\b\u0010&\u001a\u00020!H\u0004J\b\u0010'\u001a\u00020!H\u0004J\u0010\u0010(\u001a\u00020!2\b\u0010)\u001a\u0004\u0018\u00010*R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/mkui/table/DataFrameTableModel;", "R", "C", "V", "Ljavax/swing/table/TableModel;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "<init>", "(Lorg/molap/dataframe/DataFrame;)V", "listeners", "", "Ljavax/swing/event/TableModelListener;", "getListeners", "()Ljava/util/List;", "setListeners", "(Ljava/util/List;)V", "dataFrameListener", "Lorg/molap/dataframe/DataFrameListener;", "getColumnName", "", "column", "", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "getRowCount", "getColumnCount", "getValueAt", "", "rowIndex", "isCellEditable", "", "setValueAt", "", "aValue", "addTableModelListener", "l", "removeTableModelListener", "fireTableDataChanged", "fireTableStructureChanged", "fireTableChanged", "e", "Ljavax/swing/event/TableModelEvent;", "mkui-molap"})
@StabilityInferred(parameters=0)
public final class DataFrameTableModel<R, C, V>
implements TableModel {
    @NotNull
    private final DataFrame<R, C, V> dataFrame;
    @NotNull
    private List<TableModelListener> listeners;
    @NotNull
    private final DataFrameListener<R, C> dataFrameListener;
    public static final int $stable = 8;

    public DataFrameTableModel(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        this.dataFrame = dataFrame;
        this.listeners = new ArrayList();
        this.dataFrameListener = new DataFrameListener<R, C>(this){
            final /* synthetic */ DataFrameTableModel<R, C, V> this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataFrameChanged(DataFrameEvent<R, C> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                Runnable runnable = () -> dataFrameListener.1.dataFrameChanged$lambda$0(event, this.this$0);
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }

            private static final void dataFrameChanged$lambda$0(DataFrameEvent $event, DataFrameTableModel this$0) {
                if ($event.isStructureChanged()) {
                    this$0.fireTableStructureChanged();
                } else {
                    this$0.fireTableDataChanged();
                }
            }
        };
        dataFrame.addWeakDataFrameListener(this.dataFrameListener);
    }

    @NotNull
    protected final List<TableModelListener> getListeners() {
        return this.listeners;
    }

    protected final void setListeners(@NotNull List<TableModelListener> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.listeners = list;
    }

    @Override
    @Nullable
    public String getColumnName(int column) {
        Object columnKey = this.dataFrame.getColumnKey(column);
        return columnKey != null ? columnKey.toString() : null;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        return JvmClassMappingKt.getJavaClass((KClass)this.dataFrame.getColumnClass(this.dataFrame.getColumnKey(columnIndex)));
    }

    @Override
    public int getRowCount() {
        return this.dataFrame.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.dataFrame.getColumnCount();
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.dataFrame.getValueAt(this.dataFrame.getRowKey(rowIndex), this.dataFrame.getColumnKey(columnIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(@NotNull Object aValue, int rowIndex, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)aValue, (String)"aValue");
    }

    @Override
    public void addTableModelListener(@NotNull TableModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(@NotNull TableModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    protected final void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected final void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public final void fireTableChanged(@Nullable TableModelEvent e) {
        for (TableModelListener listener2 : this.listeners) {
            listener2.tableChanged(e);
        }
    }
}

