/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.table;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u000201B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0006\u0010\u001b\u001a\u00020\u0012J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0012H\u0002J(\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J(\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/mkui/table/TableColumnAdjuster;", "Ljava/beans/PropertyChangeListener;", "Ljavax/swing/event/TableModelListener;", "table", "Ljavax/swing/JTable;", "spacing", "", "<init>", "(Ljavax/swing/JTable;I)V", "isColumnHeaderIncluded", "", "isColumnDataIncluded", "isOnlyAdjustLarger", "isDynamicAdjustment", "columnSizes", "", "Ljavax/swing/table/TableColumn;", "adjustColumns", "", "adjustColumn", "column", "getColumnHeaderWidth", "getColumnDataWidth", "getCellDataWidth", "row", "updateTableColumn", "width", "restoreColumns", "restoreColumn", "setColumnHeaderIncluded", "setColumnDataIncluded", "setOnlyAdjustLarger", "setDynamicAdjustment", "propertyChange", "e", "Ljava/beans/PropertyChangeEvent;", "tableChanged", "Ljavax/swing/event/TableModelEvent;", "installActions", "installColumnAction", "isSelectedColumn", "isAdjust", "key", "", "keyStroke", "installToggleAction", "isToggleDynamic", "isToggleLarger", "ColumnAction", "ToggleAction", "mkui-molap"})
@StabilityInferred(parameters=0)
public final class TableColumnAdjuster
implements PropertyChangeListener,
TableModelListener {
    @NotNull
    private final JTable table;
    private final int spacing;
    private boolean isColumnHeaderIncluded;
    private boolean isColumnDataIncluded;
    private boolean isOnlyAdjustLarger;
    private boolean isDynamicAdjustment;
    @NotNull
    private final Map<TableColumn, Integer> columnSizes;
    public static final int $stable = 8;

    @JvmOverloads
    public TableColumnAdjuster(@NotNull JTable table, int spacing) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.spacing = spacing;
        this.columnSizes = new HashMap();
        this.setColumnHeaderIncluded(true);
        this.setColumnDataIncluded(true);
        this.setOnlyAdjustLarger(false);
        this.setDynamicAdjustment(false);
        this.installActions();
    }

    public /* synthetic */ TableColumnAdjuster(JTable jTable, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 6;
        }
        this(jTable, n);
    }

    public final void adjustColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        int n = tcm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.adjustColumn(i);
        }
    }

    public final void adjustColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        int columnHeaderWidth = this.getColumnHeaderWidth(column);
        int columnDataWidth = this.getColumnDataWidth(column);
        int preferredWidth = (int)Math.max((double)columnHeaderWidth, (double)columnDataWidth);
        this.updateTableColumn(column, preferredWidth);
    }

    private final int getColumnHeaderWidth(int column) {
        if (!this.isColumnHeaderIncluded) {
            return 0;
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Object value = tableColumn.getHeaderValue();
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.table.getTableHeader().getDefaultRenderer();
        }
        TableCellRenderer tableCellRenderer = renderer;
        Intrinsics.checkNotNull((Object)tableCellRenderer);
        Component c = tableCellRenderer.getTableCellRendererComponent(this.table, value, false, false, -1, column);
        return c.getPreferredSize().width;
    }

    private final int getColumnDataWidth(int column) {
        if (!this.isColumnDataIncluded) {
            return 0;
        }
        int preferredWidth = 0;
        int maxWidth = this.table.getColumnModel().getColumn(column).getMaxWidth();
        int n = this.table.getRowCount();
        for (int row = 0; row < n && (preferredWidth = (int)Math.max((double)preferredWidth, (double)this.getCellDataWidth(row, column))) < maxWidth; ++row) {
        }
        return preferredWidth;
    }

    private final int getCellDataWidth(int row, int column) {
        TableCellRenderer cellRenderer = this.table.getCellRenderer(row, column);
        Component c = this.table.prepareRenderer(cellRenderer, row, column);
        int width = c.getPreferredSize().width + this.table.getIntercellSpacing().width;
        return width;
    }

    private final void updateTableColumn(int column, int width) {
        int width2 = width;
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        width2 += this.spacing;
        if (this.isOnlyAdjustLarger) {
            width2 = (int)Math.max((double)width2, (double)tableColumn.getPreferredWidth());
        }
        this.columnSizes.put(tableColumn, tableColumn.getWidth());
        this.table.getTableHeader().setResizingColumn(tableColumn);
        tableColumn.setWidth(width2);
    }

    public final void restoreColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        int n = tcm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.restoreColumn(i);
        }
    }

    private final void restoreColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Integer width = this.columnSizes.get(tableColumn);
        if (width != null) {
            this.table.getTableHeader().setResizingColumn(tableColumn);
            tableColumn.setWidth(width);
        }
    }

    public final void setColumnHeaderIncluded(boolean isColumnHeaderIncluded) {
        this.isColumnHeaderIncluded = isColumnHeaderIncluded;
    }

    public final void setColumnDataIncluded(boolean isColumnDataIncluded) {
        this.isColumnDataIncluded = isColumnDataIncluded;
    }

    public final void setOnlyAdjustLarger(boolean isOnlyAdjustLarger) {
        this.isOnlyAdjustLarger = isOnlyAdjustLarger;
    }

    public final void setDynamicAdjustment(boolean isDynamicAdjustment) {
        if (this.isDynamicAdjustment != isDynamicAdjustment) {
            if (isDynamicAdjustment) {
                this.table.addPropertyChangeListener(this);
                this.table.getModel().addTableModelListener(this);
            } else {
                this.table.removePropertyChangeListener(this);
                this.table.getModel().removeTableModelListener(this);
            }
        }
        this.isDynamicAdjustment = isDynamicAdjustment;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)"model", (Object)e.getPropertyName())) {
            Object object = e.getOldValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.table.TableModel");
            TableModel model = (TableModel)object;
            model.removeTableModelListener(this);
            Object object2 = e.getNewValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.table.TableModel");
            model = (TableModel)object2;
            model.addTableModelListener(this);
            this.adjustColumns();
        }
    }

    @Override
    public void tableChanged(@NotNull TableModelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isColumnDataIncluded) {
            return;
        }
        SwingUtilities.invokeLater(() -> TableColumnAdjuster.tableChanged$lambda$0(this, e));
    }

    private final void installActions() {
        this.installColumnAction(true, true, "adjustColumn", "control ADD");
        this.installColumnAction(false, true, "adjustColumns", "control shift ADD");
        this.installColumnAction(true, false, "restoreColumn", "control SUBTRACT");
        this.installColumnAction(false, false, "restoreColumns", "control shift SUBTRACT");
        this.installToggleAction(true, false, "toggleDynamic", "control MULTIPLY");
        this.installToggleAction(false, true, "toggleLarger", "control DIVIDE");
    }

    private final void installColumnAction(boolean isSelectedColumn, boolean isAdjust, String key, String keyStroke) {
        Action action = new ColumnAction(isSelectedColumn, isAdjust);
        KeyStroke ks = KeyStroke.getKeyStroke(keyStroke);
        this.table.getInputMap().put(ks, key);
        this.table.getActionMap().put(key, action);
    }

    private final void installToggleAction(boolean isToggleDynamic, boolean isToggleLarger, String key, String keyStroke) {
        Action action = new ToggleAction(isToggleDynamic, isToggleLarger);
        KeyStroke ks = KeyStroke.getKeyStroke(keyStroke);
        this.table.getInputMap().put(ks, key);
        this.table.getActionMap().put(key, action);
    }

    @JvmOverloads
    public TableColumnAdjuster(@NotNull JTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this(table, 0, 2, null);
    }

    private static final void tableChanged$lambda$0(TableColumnAdjuster this$0, TableModelEvent $e) {
        int column = this$0.table.convertColumnIndexToView($e.getColumn());
        if ($e.getType() == 0 && column != -1) {
            if (this$0.isOnlyAdjustLarger) {
                int row = $e.getFirstRow();
                TableColumn tableColumn = this$0.table.getColumnModel().getColumn(column);
                if (tableColumn.getResizable()) {
                    int width = this$0.getCellDataWidth(row, column);
                    this$0.updateTableColumn(column, width);
                }
            } else {
                this$0.adjustColumn(column);
            }
        } else {
            this$0.adjustColumns();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/mkui/table/TableColumnAdjuster$ColumnAction;", "Ljavax/swing/AbstractAction;", "isSelectedColumn", "", "isAdjust", "<init>", "(Lorg/mkui/table/TableColumnAdjuster;ZZ)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "mkui-molap"})
    public final class ColumnAction
    extends AbstractAction {
        private final boolean isSelectedColumn;
        private final boolean isAdjust;

        public ColumnAction(boolean isSelectedColumn, boolean isAdjust) {
            this.isSelectedColumn = isSelectedColumn;
            this.isAdjust = isAdjust;
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.isSelectedColumn) {
                int[] columns = TableColumnAdjuster.this.table.getSelectedColumns();
                int n = columns.length;
                for (int i = 0; i < n; ++i) {
                    if (this.isAdjust) {
                        TableColumnAdjuster.this.adjustColumn(columns[i]);
                        continue;
                    }
                    TableColumnAdjuster.this.restoreColumn(columns[i]);
                }
            } else if (this.isAdjust) {
                TableColumnAdjuster.this.adjustColumns();
            } else {
                TableColumnAdjuster.this.restoreColumns();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/mkui/table/TableColumnAdjuster$ToggleAction;", "Ljavax/swing/AbstractAction;", "isToggleDynamic", "", "isToggleLarger", "<init>", "(Lorg/mkui/table/TableColumnAdjuster;ZZ)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "mkui-molap"})
    public final class ToggleAction
    extends AbstractAction {
        private final boolean isToggleDynamic;
        private final boolean isToggleLarger;

        public ToggleAction(boolean isToggleDynamic, boolean isToggleLarger) {
            this.isToggleDynamic = isToggleDynamic;
            this.isToggleLarger = isToggleLarger;
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.isToggleDynamic) {
                TableColumnAdjuster.this.setDynamicAdjustment(!TableColumnAdjuster.this.isDynamicAdjustment);
                return;
            }
            if (this.isToggleLarger) {
                TableColumnAdjuster.this.setOnlyAdjustLarger(!TableColumnAdjuster.this.isOnlyAdjustLarger);
                return;
            }
        }
    }
}

