package org.mkui.canvas

interface KeyEvent {
    val keyCode: Int

    companion object {
        const val VK_ENTER = '\n'.toInt()
        const val VK_BACK_SPACE = '\b'.toInt()
        const val VK_TAB = '\t'.toInt()
        const val VK_CANCEL = 0x03
        const val VK_CLEAR = 0x0C
        const val VK_SHIFT = 0x10
        const val VK_CONTROL = 0x11
        const val VK_ALT = 0x12
        const val VK_PAUSE = 0x13
        const val VK_CAPS_LOCK = 0x14
        const val VK_ESCAPE = 0x1B
        const val VK_SPACE = 0x20
        const val VK_PAGE_UP = 0x21
        const val VK_PAGE_DOWN = 0x22
        const val VK_END = 0x23
        const val VK_HOME = 0x24

        /**
         * Constant for the non-numpad **left** arrow key.
         * @see .VK_KP_LEFT
         */
        const val VK_LEFT = 0x25

        /**
         * Constant for the non-numpad **up** arrow key.
         * @see .VK_KP_UP
         */
        const val VK_UP = 0x26

        /**
         * Constant for the non-numpad **right** arrow key.
         * @see .VK_KP_RIGHT
         */
        const val VK_RIGHT = 0x27

        /**
         * Constant for the non-numpad **down** arrow key.
         * @see .VK_KP_DOWN
         */
        const val VK_DOWN = 0x28
        const val VK_A = 0x41
        const val VK_B = 0x42
        const val VK_C = 0x43
        const val VK_D = 0x44
        const val VK_E = 0x45
        const val VK_F = 0x46
        const val VK_G = 0x47
        const val VK_H = 0x48
        const val VK_I = 0x49
        const val VK_J = 0x4A
        const val VK_K = 0x4B
        const val VK_L = 0x4C
        const val VK_M = 0x4D
        const val VK_N = 0x4E
        const val VK_O = 0x4F
        const val VK_P = 0x50
        const val VK_Q = 0x51
        const val VK_R = 0x52
        const val VK_S = 0x53
        const val VK_T = 0x54
        const val VK_U = 0x55
        const val VK_V = 0x56
        const val VK_W = 0x57
        const val VK_X = 0x58
        const val VK_Y = 0x59
        const val VK_Z = 0x5A
    }
}
