/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.colormap.property

import com.macrofocus.common.properties.AbstractMutableProperty
import com.macrofocus.common.properties.PropertyEvent
import org.mkui.colormap.ColorMapEvent
import org.mkui.colormap.ColorMapListener
import org.mkui.colormap.MutableColorMap

class MutableColorMapProperty(colorMap: MutableColorMap?) : AbstractMutableProperty<MutableColorMap?>() {
    private var colorMap: MutableColorMap? = null
    private val colorMapListener: ColorMapListener = object : ColorMapListener {
        override fun colorMapChanged(event: ColorMapEvent) {
            notifyPropertyChanged(PropertyEvent(null, colorMap))
        }
    }
    override var value: MutableColorMap?
        get() = colorMap
        set(value) {
            if (colorMap != null) {
                colorMap!!.removeColorMapListener(colorMapListener)
            }
            val old: MutableColorMap? = colorMap
            colorMap = value
            if (colorMap != null) {
                colorMap!!.addColorMapListener(colorMapListener)
            }
            notifyPropertyChanged(PropertyEvent<MutableColorMap?>(old, colorMap))
        }

    init {
        value = colorMap
    }
}