package org.mkui.component

import org.mkui.component.CPComponent
import org.mkui.component.label.CPLabel
import org.mkui.component.panel.CPVerticalPanel

private val factory = DefaultComponentFactory()

fun verticalPanel(build: VerticalPanelBuilder.() -> Unit) : CPVerticalPanel =
    factory.verticalPanel(build)

fun label(label: String = "", build: (CPLabel.() -> Unit)? = null) : CPLabel =
    factory.label(label, build)

interface ComponentFactory {
    fun verticalPanel(build: VerticalPanelBuilder.() -> Unit): CPVerticalPanel

    fun label(label: String = "", build: (CPLabel.() -> Unit)? = null): CPLabel
}