/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.geom

class Ellipse : Geometry {
    var x = 0.0
    var y = 0.0
    var width = 0.0
    var height = 0.0

    constructor() {}
    constructor(x: Double, y: Double, width: Double, height: Double) {
        this.x = x
        this.y = y
        this.width = width
        this.height = height
    }

    override operator fun contains(point: Point2D): Boolean {
        // Normalize the coordinates compared to the ellipse
        // having a center at 0,0 and a radius of 0.5.
        val ellw = width
        if (ellw <= 0.0) {
            return false
        }
        val normx: Double = (point.x - x) / ellw - 0.5
        val ellh = height
        if (ellh <= 0.0) {
            return false
        }
        val normy: Double = (point.y - y) / ellh - 0.5
        return normx * normx + normy * normy < 0.25
    }

    override fun toString(): String {
        return "Ellipse{" +
                "x=" + x +
                ", y=" + y +
                ", width=" + width +
                ", height=" + height +
                '}'
    }
}