/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.geom

import kotlin.math.ceil
import kotlin.math.floor

interface Shape {
    val bounds: Rectangle?
        get() {
            val b: Rectangle2D = bounds2D
            val width: Double = b.width
            val height: Double = b.height
            if (width < 0 || height < 0) {
                return Rectangle()
            }
            val x: Double = b.x
            val y: Double = b.y
            val x1: Double = floor(x)
            val y1: Double = floor(y)
            val x2: Double = ceil(x + width)
            val y2: Double = ceil(y + height)
            return Rectangle(
                x1.toInt(), y1.toInt(),
                (x2 - x1).toInt(), (y2 - y1).toInt()
            )
        }
    val bounds2D: Rectangle2D
    operator fun contains(point: Point2D): Boolean
    fun intersects(rect: Rectangle2D): Boolean
    val pathIterator: PathIterator
    fun getPathIterator(at: AffineTransform? = null): PathIterator
    fun getFlattenPathIterator(flatness: Double): PathIterator
}