package org.mkui.geom.curve

/**
 * The CatmullRomSpline is equal to the CardinalSpline with the value of alpha fixed at 0.5.
 * The implementation for the CatmullRomSpline is about 10% faster then the CardinalSpline
 * implementation.
 *
 * @see CardinalSpline
 */
class CatmullRomSpline(cp: ControlPath?, gi: GroupIterator?) : ParametricCurve(cp, gi) {
    private val pt = arrayOfNulls<DoubleArray>(4)

    /**
     * The requirements for this curve are the group-iterator must be in-range and have a group size of at least 4.
     * If these requirements are not met then this method returns quietly.
     */
    override fun appendTo(mp: MultiPath) {
        if (!gi!!.isInRange(0, cp!!.numPoints())) return
        if (gi!!.groupSize < 4) return
        gi!!.set(0, 0)
        for (i in 0..3) pt[i] = cp!!.getPoint(gi!!.next())!!.location
        val d = DoubleArray(mp.dimension + 1)
        eval(d)
        if (connect) mp.lineTo(d) else mp.moveTo(d)
        gi!!.set(0, 0)
        while (true) {
            val index_i: Int = gi!!.index_i()
            val count_j: Int = gi!!.count_j()
            for (i in 0..3) {
                if (!gi!!.hasNext()) return
                pt[i] = cp!!.getPoint(gi!!.next())!!.location
            }
            gi!!.set(index_i, count_j)
            gi!!.next()
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp)
        }
    }

    override fun eval(p: DoubleArray) {
        val t = p[p.size - 1]
        val t2 = t * t
        val t3 = t2 * t

        // Note: The 0.5 does NOT represent alpha. It is a result of the simplification.
        for (i in 0 until p.size - 1) {
            p[i] =
                0.5 * ((pt[3]!![i] - pt[0]!![i] + 3 * (pt[1]!![i] - pt[2]!![i])) * t3 + (2 * (pt[0]!![i] + 2 * pt[2]!![i]) - 5 * pt[1]!![i] - pt[3]!![i]) * t2 + (pt[2]!![i] - pt[0]!![i]) * t) + pt[1]!![i]
        }
    }

    /**
     * Returns a value of 1.
     */
    override val sampleLimit: Int
        get() = 1
}