package org.mkui.rubberband

import com.macrofocus.common.selection.MutableSingleSelection
import com.macrofocus.common.selection.SimpleSingleSelection
import org.mkui.geom.Rectangle
import org.mkui.geom.Rectangle2D
import org.mkui.transform.TwoDScreenTransform
import kotlin.math.round

class ScreenTransformRubberBand(screenTransform: TwoDScreenTransform) : RubberBand {
    override val rubberBand: MutableSingleSelection<Rectangle2D?> = SimpleSingleSelection<Rectangle2D?>(null)
    private val screenTransform: TwoDScreenTransform

    /**
     * {@inheritDoc}
     */
    override fun startRubberBand(x: Int, y: Int) {
        val xWorld: Double = screenTransform.x.screenToWorld(x)
        val yWorld: Double = screenTransform.y.screenToWorld(y)
        rubberBand.selected = Rectangle2D.Double(xWorld, yWorld, 0.0, 0.0)
    }

    /**
     * {@inheritDoc}
     */
    override fun stretchRubberBand(x: Int, y: Int) {
        if (rubberBand.isActive) {
            val xWorld: Double = screenTransform.x.screenToWorld(x)
            val yWorld: Double = screenTransform.y.screenToWorld(y)
            val r: Rectangle2D = rubberBand.selected!!
            rubberBand.selected = Rectangle2D.Double(r.x, r.y, xWorld - r.x, yWorld - r.y)
        }
    }

    /**
     * {@inheritDoc}
     */
    override fun stopRubberBand() {
        rubberBand.clearSelection()
    }

    /**
     * {@inheritDoc}
     */
    override val rubberBandScreen: Rectangle2D?
        get() = if (rubberBand.isActive) {
            worldToScreen(rubberBand.selected!!).normalize()
        } else {
            null
        }

    /**
     * {@inheritDoc}
     */
    fun worldToScreen(r: Rectangle2D): Rectangle2D {
        val x1 = round(screenTransform.x.worldToScreenPrecise(r.minX)).toInt()
        val x2 = round(screenTransform.x.worldToScreenPrecise(r.maxX)).toInt()
        val y1 = round(screenTransform.y.worldToScreenPrecise(r.minY)).toInt()
        val y2 = round(screenTransform.y.worldToScreenPrecise(r.maxY)).toInt()
        val width = x2 - x1
        val height = y2 - y1
        return Rectangle(x1, y1, width, height)
    }

    init {
        this.screenTransform = screenTransform
    }
}
