package org.mkui.canvas

import com.macrofocus.common.crossplatform.CPHelper
import javafx.scene.input.MouseButton

class JavaFXMouseEvent(private val event: javafx.scene.input.MouseEvent) : MouseEvent {
    override val x: Int
        get() = event.x.toInt()
    override val y: Int
        get() = event.y.toInt()
    override val isMenuShortcutKeyDown: Boolean
        get() = event.isControlDown || event.isMetaDown
    override val isAltKeyDown: Boolean
        get() = event.isAltDown
    override val isShiftKeyDown: Boolean
        get() = event.isShiftDown
    override val isMultipleSelectionKey: Boolean
        get() = if (CPHelper.instance.isMac) {
            event.isMetaDown
        } else {
            event.isControlDown
        }
    override val isPopupTrigger: Boolean
        get() = event.isPopupTrigger
    override val isLeftMouseButton: Boolean
        get() = event.button == MouseButton.PRIMARY
    override val isMiddleMouseButton: Boolean
        get() = event.button == MouseButton.MIDDLE

    override fun stopPropagation() {
        event.consume()
    }

    override val clickCount: Int
        get() = event.clickCount

    override fun toString(): String {
        return "JavaFXMouseEvent{" +
                "event=" + event +
                '}'
    }
}
