package org.mkui.canvas

import javafx.scene.canvas.Canvas


open class ResizableCanvas : Canvas() {
    override fun isResizable(): Boolean {
        return true
    }

    override fun minWidth(height: Double): Double {
        return 0.0
    }

    override fun minHeight(width: Double): Double {
        return 0.0
    }

    override fun prefWidth(height: Double): Double {
        return width
    }

    override fun prefHeight(width: Double): Double {
        return height
    }

    override fun maxWidth(height: Double): Double {
        return Double.MAX_VALUE
    }

    override fun maxHeight(width: Double): Double {
        return Double.MAX_VALUE
    }
}