package org.mkui.color

import javafx.scene.paint.Color

actual class CPColor constructor(val color: Color) : IColor {
    actual constructor(r: UByte, g: UByte, b: UByte, a: UByte) : this(Color(r.toDouble() / 255.0, g.toDouble() / 255.0, b.toDouble() / 255.0, a.toDouble() / 255.0))
    actual constructor(r: UByte, g: UByte, b: UByte) : this(r, g, b, 255u)
    actual constructor(r: Int, g: Int, b: Int) : this(r.toUByte(), g.toUByte(), b.toUByte(),255u)
    actual constructor(r: Int, g: Int, b: Int, a: Int) : this(r.toUByte(), g.toUByte(), b.toUByte(), a.toUByte())
    actual constructor(r: Float, g: Float, b: Float) : this(Color(r.toDouble(), g.toDouble(), b.toDouble(), 1.0))
    actual constructor(r: Float, g: Float, b: Float, a: Float) : this(Color(r.toDouble(), g.toDouble(), b.toDouble(), a.toDouble()))

    actual constructor(rgba: Int) : this(
        rgba shr 16 and 0xff,
        rgba shr 8 and 0xff,
        rgba shr 0 and 0xff,
        rgba shr 24 and 0xff)

    override fun getRed(): UByte {
        return Math.round(color.red * 255.0).toUByte();
    }

    override fun getGreen(): UByte {
        return Math.round(color.green * 255.0).toUByte();
    }

    override fun getBlue(): UByte {
        return Math.round(color.blue * 255.0).toUByte();
    }

    override fun getAlpha(): UByte {
        return Math.round(color.opacity * 255.0).toUByte();
    }

    fun getNative(): NColor {
        return color;
    }
}