package org.mkui.font

import javafx.scene.text.Font
import javafx.scene.text.FontPosture
import javafx.scene.text.FontWeight

actual class CPFont {
    val nativeFont: Font
    private val fontWeight: FontWeight?
    private val fontPosture: FontPosture?

    constructor(nativeFont: Font, fontWeight: FontWeight? = null, fontPosture: FontPosture? = null) {
        this.nativeFont = nativeFont
        this.fontWeight = fontWeight
        this.fontPosture = fontPosture
    }

    actual fun getSize(): Double {
        return nativeFont.getSize()
    }

    actual fun deriveFontSize(fontSize: Double): CPFont {
        return CPFont(
            Font.font(nativeFont.family, fontSize),
            fontWeight,
            fontPosture
        )
    }

    actual fun getSize2D(): Double {
        return nativeFont.size
    }

    actual fun deriveFontWeight(weight: Weight): CPFont {
        var w: FontWeight? = null
        when (weight) {
            Weight.NORMAL -> w = FontWeight.NORMAL
            Weight.BOLD -> w = FontWeight.BOLD
        }

        return CPFont(
            Font.font(nativeFont.family, w, nativeFont.size),
            w,
            fontPosture
        )
    }

}