package org.mkui.font

import javafx.scene.text.Font
import javafx.scene.text.FontPosture
import javafx.scene.text.FontWeight

actual class CPFontFactory {
    actual fun createFont(family: String?, style: Weight, size: Int): CPFont? {
        TODO("Not yet implemented")
    }

    actual fun createFont(family: String?, style: Int, size: Int): CPFont? {
        val fontWeight: FontWeight
        if (style and java.awt.Font.BOLD !== 0) {
            fontWeight = FontWeight.BOLD
        } else {
            fontWeight = FontWeight.NORMAL
        }
        val fontPosture: FontPosture
        if (style and java.awt.Font.ITALIC !== 0) {
            fontPosture = FontPosture.ITALIC
        } else {
            fontPosture = FontPosture.REGULAR
        }

        return CPFont(Font.font(family, fontWeight, fontPosture, size.toDouble()))
    }

    actual fun decodeFont(labelingFont: String?): CPFont? {
        var fontName: String = labelingFont!!
        var styleName = ""
        var fontSize = 12
        var fontStyle: Int = java.awt.Font.PLAIN

        if (labelingFont == null) {
            return null
        }

        val lastHyphen: Int = labelingFont.lastIndexOf('-')
        val lastSpace: Int = labelingFont.lastIndexOf(' ')
        val sepChar = if (lastHyphen > lastSpace) '-' else ' '
        var sizeIndex: Int = labelingFont.lastIndexOf(sepChar)
        var styleIndex: Int = labelingFont.lastIndexOf(sepChar, sizeIndex - 1)
        val strlen: Int = labelingFont.length

        if (sizeIndex > 0 && sizeIndex + 1 < strlen) {
            try {
                fontSize = Integer.valueOf(labelingFont.substring(sizeIndex + 1)).toInt()
                if (fontSize <= 0) {
                    fontSize = 12
                }
            } catch (e: NumberFormatException) {
                /* It wasn't a valid size, if we didn't also find the
                 * start of the style string perhaps this is the style */
                styleIndex = sizeIndex
                sizeIndex = strlen
                if (labelingFont.get(sizeIndex - 1) == sepChar) {
                    sizeIndex--
                }
            }
        }

        if (styleIndex >= 0 && styleIndex + 1 < strlen) {
            styleName = labelingFont.substring(styleIndex + 1, sizeIndex)
            styleName = styleName.toLowerCase()
            if (styleName == "bolditalic") {
                fontStyle = java.awt.Font.BOLD or java.awt.Font.ITALIC
            } else if (styleName == "italic") {
                fontStyle = java.awt.Font.ITALIC
            } else if (styleName == "bold") {
                fontStyle = java.awt.Font.BOLD
            } else if (styleName == "plain") {
                fontStyle = java.awt.Font.PLAIN
            } else {
                /* this string isn't any of the expected styles, so
                 * assume its part of the font name
                 */
                styleIndex = sizeIndex
                if (labelingFont.get(styleIndex - 1) == sepChar) {
                    styleIndex--
                }
            }
            fontName = labelingFont.substring(0, styleIndex)
        } else {
            var fontEnd = strlen
            if (styleIndex > 0) {
                fontEnd = styleIndex
            } else if (sizeIndex > 0) {
                fontEnd = sizeIndex
            }
            if (fontEnd > 0 && labelingFont.get(fontEnd - 1) == sepChar) {
                fontEnd--
            }
            fontName = labelingFont.substring(0, fontEnd)
        }
        return createFont(fontName, fontStyle, fontSize)
    }

    actual fun createFontFamily(family: String?): CPFont? {
        val font = Font.font(family)
        return font?.let { CPFont(it) }
    }

    actual fun decodeFontWithDefault(
        labelingFont: String?,
        defaultLabelingFont: CPFont?
    ): CPFont? {
        val f: CPFont? = decodeFont(labelingFont)
        return if (f != null) {
            f
        } else {
            defaultLabelingFont
        }
    }

    actual fun createDefaultFont(): CPFont {
        return createFontFamily("Arial")!!
    }

    actual companion object {
        actual val instance: CPFontFactory
            get() = CPFontFactory()
    }

}