package org.mkui.graphics

import javafx.scene.canvas.GraphicsContext
import javafx.scene.paint.Color
import javafx.scene.paint.CycleMethod
import javafx.scene.paint.LinearGradient
import javafx.scene.paint.Stop
import javafx.scene.shape.ArcType
import javafx.scene.text.Font
import org.mkui.color.CPColor
import org.mkui.font.CPFont
import org.mkui.text.CPTextMetrics

actual class CPGraphicsContext2D(val gc: GraphicsContext) : GraphicsContext2D {
    override fun getTextMetrics(text: String): CPTextMetrics {
        return JavaFXTextMetrics(gc, text)
    }

    override fun drawGradient(
        color1: CPColor,
        color2: CPColor,
        x: Double,
        y: Double,
        w: Double,
        h: Double,
        isVertical: Boolean
    ) {
        if (isVertical) {
            gc.fill = LinearGradient(
                0.0,
                y,
                0.0,
                y + h,
                false,
                CycleMethod.NO_CYCLE,
                Stop(0.0, color1.color),
                Stop(1.0, color2.color)
            )
            gc.fillRect(x, y, w, h)
        } else {
            gc.fill = LinearGradient(
                x,
                0.0,
                x + w,
                0.0,
                false,
                CycleMethod.NO_CYCLE,
                Stop(0.0, color1.color),
                Stop(1.0, color2.color)
            )
            gc.fillRect(x, y, w, h)
        }
    }

    override fun save() {
        gc.save()
    }

    override fun restore() {
        gc.restore()
    }

    override fun translate(x: Double, y: Double) {
        gc.translate(x, y)
    }

    override fun scale(x: Double, y: Double) {
        gc.scale(x, y)
    }

    override fun rotate(degrees: Double) {
        gc.rotate(degrees)
    }

    override fun transform(
        mxx: Double,
        myx: Double,
        mxy: Double,
        myy: Double,
        mxt: Double,
        myt: Double
    ) {
        gc.transform(mxx, myx, mxy, myy, mxt, myt)
    }

    override fun setTransform(
        mxx: Double,
        myx: Double,
        mxy: Double,
        myy: Double,
        mxt: Double,
        myt: Double
    ) {
        gc.setTransform(mxx, myx, mxy, myy, mxt, myt)
    }

    //    @Override
    fun getGlobalAlpha(): Double {
        return gc.globalAlpha
    }

    override fun setGlobalAlpha(alpha: Double) {
        gc.globalAlpha = alpha
    }

    //    @Override
    fun getFill(): Color? {
        return gc.fill as Color
    }

    override fun setFill(p: CPColor) {
        gc.fill = p.color
    }

    //    @Override
    fun getStroke(): Color? {
        return gc.stroke as Color
    }

    override fun setStroke(p: CPColor) {
        gc.stroke = p.color
    }

    //    @Override
    fun getLineWidth(): Double {
        return gc.lineWidth
    }

    override fun setLineWidth(lw: Double) {
        gc.lineWidth = lw
    }

    //    @Override
    fun getMiterLimit(): Double {
        return gc.miterLimit
    }

    //    @Override
    fun setMiterLimit(ml: Double) {
        gc.miterLimit = ml
    }

    //    @Override
    fun getLineDashes(): DoubleArray? {
        return gc.lineDashes
    }

    //    @Override
    fun setLineDashes(vararg dashes: Double) {
        gc.setLineDashes(*dashes)
    }

    //    @Override
    fun getLineDashOffset(): Double {
        return gc.lineDashOffset
    }

    //    @Override
    fun setLineDashOffset(dashOffset: Double) {
        gc.lineDashOffset = dashOffset
    }

    //    @Override
    fun getFont(): Font? {
        return gc.font
    }

    override fun setFont(f: CPFont) {
        gc.font = f.nativeFont
    }

    override fun fillText(text: String, x: Double, y: Double) {
        gc.fillText(text, x, y)
    }

    override fun beginPath() {
        gc.beginPath()
    }

    override fun moveTo(x0: Double, y0: Double) {
        gc.moveTo(x0, y0)
    }

    override fun lineTo(x1: Double, y1: Double) {
        gc.lineTo(x1, y1)
    }

    override fun quadraticCurveTo(xc: Double, yc: Double, x1: Double, y1: Double) {
        gc.quadraticCurveTo(xc, yc, x1, y1)
    }

    override fun bezierCurveTo(
        xc1: Double,
        yc1: Double,
        xc2: Double,
        yc2: Double,
        x1: Double,
        y1: Double
    ) {
        gc.bezierCurveTo(xc1, yc1, xc2, yc2, x1, y1)
    }

    override fun rect(x: Double, y: Double, w: Double, h: Double) {
        gc.rect(x, y, w, h)
    }

    override fun closePath() {
        gc.closePath()
    }

    override fun fill() {
        gc.fill()
    }

    override fun stroke() {
        gc.stroke()
    }

//    @Override
//    public void arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
//        gc.arc(centerX, centerY, radiusX, radiusY, startAngle, length);
//    }

    //    @Override
    //    public void arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
    //        gc.arc(centerX, centerY, radiusX, radiusY, startAngle, length);
    //    }
    override fun clip() {
        gc.clip()
    }

    override fun fillRect(x: Double, y: Double, w: Double, h: Double) {
        gc.fillRect(x, y, w, h)
    }

    override fun strokeRect(x: Double, y: Double, w: Double, h: Double) {
        gc.strokeRect(x, y, w, h)
    }

    override fun strokeLine(x1: Double, y1: Double, x2: Double, y2: Double) {
        gc.strokeLine(x1, y1, x2, y2)
    }

    //    @Override
    fun strokeText(text: String?, x: Double, y: Double) {
        gc.strokeText(text, x, y)
    }

    //    @Override
    fun fillText(text: String?, x: Double, y: Double, maxWidth: Double) {
        gc.fillText(text, x, y, maxWidth)
    }

    //    @Override
    fun strokeText(
        text: String?,
        x: Double,
        y: Double,
        maxWidth: Double
    ) {
        gc.strokeText(text, x, y, maxWidth)
    }

    //    @Override
    fun arcTo(
        x1: Double,
        y1: Double,
        x2: Double,
        y2: Double,
        radius: Double
    ) {
        gc.arcTo(x1, y1, x2, y2, radius)
    }

    //    @Override
    fun appendSVGPath(svgpath: String?) {
        gc.appendSVGPath(svgpath)
    }

    //    @Override
    fun isPointInPath(x: Double, y: Double): Boolean {
        return gc.isPointInPath(x, y)
    }

    //    @Override
    fun clearRect(x: Double, y: Double, w: Double, h: Double) {
        gc.clearRect(x, y, w, h)
    }

    //    @Override
    fun fillOval(x: Double, y: Double, w: Double, h: Double) {
        gc.fillOval(x, y, w, h)
    }

    //    @Override
    fun strokeOval(x: Double, y: Double, w: Double, h: Double) {
        gc.strokeOval(x, y, w, h)
    }

    //    @Override
    fun fillArc(
        x: Double,
        y: Double,
        w: Double,
        h: Double,
        startAngle: Double,
        arcExtent: Double,
        closure: ArcType?
    ) {
        gc.fillArc(x, y, w, h, startAngle, arcExtent, closure)
    }

    //    @Override
    fun strokeArc(
        x: Double,
        y: Double,
        w: Double,
        h: Double,
        startAngle: Double,
        arcExtent: Double,
        closure: ArcType?
    ) {
        gc.strokeArc(x, y, w, h, startAngle, arcExtent, closure)
    }

    //    @Override
    fun fillRoundRect(
        x: Double,
        y: Double,
        w: Double,
        h: Double,
        arcWidth: Double,
        arcHeight: Double
    ) {
        gc.fillRoundRect(x, y, w, h, arcWidth, arcHeight)
    }

    //    @Override
    fun strokeRoundRect(
        x: Double,
        y: Double,
        w: Double,
        h: Double,
        arcWidth: Double,
        arcHeight: Double
    ) {
        gc.strokeRoundRect(x, y, w, h, arcWidth, arcHeight)
    }

    //    @Override
    fun fillPolygon(xPoints: DoubleArray?, yPoints: DoubleArray?, nPoints: Int) {
        gc.fillPolygon(xPoints, yPoints, nPoints)
    }

    //    @Override
    fun strokePolygon(xPoints: DoubleArray?, yPoints: DoubleArray?, nPoints: Int) {
        gc.strokePolygon(xPoints, yPoints, nPoints)
    }

    //    @Override
    fun strokePolyline(xPoints: DoubleArray?, yPoints: DoubleArray?, nPoints: Int) {
        gc.strokePolyline(xPoints, yPoints, nPoints)
    }
}