package org.mkui.graphics

import javafx.scene.canvas.GraphicsContext
import javafx.scene.text.Text
import org.mkui.text.CPTextMetrics


/**
 * Created by luc on 09/07/15.
 */
class JavaFXTextMetrics(private val context: GraphicsContext, text: String?) : CPTextMetrics {
    private val width = computeWidth(text)
    private val ascent = computeAscent()

    override fun getWidth(): Double {
        return width
    }

    override fun getAscent(): Double {
        return ascent
    }

    private fun computeWidth(text: String?): Double {
        val t = Text(text)
        t.font = context.font
        //        t.applyCss();
        val stringBounds = t.layoutBounds
        return stringBounds.width
    }

    private fun computeAscent() : Double {
        val t = Text("M")
        t.font = context.font
        //        t.applyCss();
        val stringBounds = t.layoutBounds
        return stringBounds.height
    }
}
