package org.mkui.canvas

import org.w3c.dom.Element
import org.w3c.dom.HTMLCanvasElement
import org.w3c.dom.HTMLElement

class ElementalCanvasHandler(private val nativeComponent: org.mkui.canvas.FunctionalCPCanvas, private val canvas: HTMLCanvasElement,
                             val mouseListeners : MutableList<MouseListener>,
                             val mouseMotionListeners: MutableList<MouseMotionListener>,
                             val mouseWheelListeners: MutableList<MouseWheelListener>,
                             val keyListeners: MutableList<KeyListener>,
                             val contextMenuListeners: MutableList<ContextMenuListener>
                             ) {
    private var keyListenerRegistered = false
    private var mouseEntered = false
    private var dragging = false
//    private val mouseMove: HandlerRegistration? = null
    var onmousemove: ((org.w3c.dom.events.MouseEvent) -> dynamic)? = null

    init {
        registerMouseListener()
        registerMouseMotionListener()
        registerMouseWheelListener()
        registerKeyListener()
        registerContextMenuListener()
    }

    fun registerMouseListener() {
        if (canvas != null) {
            canvas.onmouseup = {
                for (l in mouseListeners) {
                    l.mouseClicked(org.mkui.canvas.JSMouseEvent(it, 0))
                    if (dragging) {
                        stopDragging()
                    }
                    l.mouseReleased(org.mkui.canvas.JSMouseEvent(it, 0))
                }
            }
            canvas.onmousedown = {
                if (!dragging) {
                    startDragging()
                }
                for (l in mouseListeners) {
                    l.mousePressed(org.mkui.canvas.JSMouseEvent(it, 1))
                }
            }
            canvas.onmouseover = {
                if (!mouseEntered) {
                    mouseEntered = true
                    if (keyListenerRegistered) {
//                            Scheduler.get().scheduleDeferred(object : ScheduledCommand() {
//                                fun execute() {
//                                    if (nativeComponent is FocusWidget) {
//                                        (nativeComponent as FocusWidget).setFocus(true)
//                                    }
//                                }
//                            })
                    }
                    if (!dragging) {
                        for (l in mouseListeners) {
                            l.mouseEntered(org.mkui.canvas.JSMouseEvent(it, 0))
                        }
                    }
                } else {
                }
            }
        }
        canvas.onmouseout = {
            mouseEntered = false
            //                stopDragging();
            if (!dragging) {
                for (l in mouseListeners) {
                    l.mouseExited(org.mkui.canvas.JSMouseEvent(it, 0))
                }
            }
        }
        canvas.ondblclick = {
            for (l in mouseListeners) {
                l.mousePressed(org.mkui.canvas.JSMouseEvent(it, 2))
            }
        }
    }

    fun registerMouseMotionListener() {
        if (canvas != null) {
            onmousemove = {
                if (!dragging) {
                    for (l in mouseMotionListeners) {
                        l.mouseMoved(org.mkui.canvas.JSMouseEvent(it, 0))
                    }
                }
            }
            canvas.onmousemove = onmousemove
//            canvas.ontouchmove =  {
//            }
        }
    }

    fun registerMouseWheelListener() {
        if (canvas != null) {
//                canvas.onmousewheel = {
//                        l.mouseWheelMoved(object : MouseWheelEvent {
//                            override val x: Int
//                                get() = (it as WheelEvent).x.toInt()
//                            override val y: Int
//                                get() = (it as WheelEvent).y.toInt()
//                            override val wheelRotation: Int
//                                get() = (it as WheelEvent).deltaY.toInt()
//                        })
//                    }
        }
    }

    fun startDragging() {
        dragging = true
        if (canvas != null) {
//            com.google.gwt.user.client.Event.setCapture(canvas.getElement());
            canvas.onmousemove =  {
                for (mouseMotionListener in mouseMotionListeners) {
                    mouseMotionListener.mouseDragged(org.mkui.canvas.JSMouseEvent(it, 0))
                }
                it.stopPropagation()
            }
        }
    }

    fun stopDragging() {
        if (dragging) {
//            com.google.gwt.user.client.Event.releaseCapture(nativeComponent.getCanvas().getElement());
            dragging = false
            canvas.onmousemove = onmousemove
        }
    }

    fun registerKeyListener() {
        keyListenerRegistered = true
//        nativeComponent.sinkEvents(com.google.gwt.user.client.Event.KEYEVENTS)
        canvas.onkeydown = {
            var code = -1
            when (it.keyCode) {
//                KeyCodes.KEY_DOWN -> code = VK_DOWN
//                KeyCodes.KEY_UP -> code = VK_UP
//                KeyCodes.KEY_PAGEDOWN -> code = VK_PAGE_DOWN
//                KeyCodes.KEY_PAGEUP -> code = VK_PAGE_UP
//                else -> code = it.keyCode
            }
            if (code >= 0) {
                for (l in keyListeners) {
                    l.keyPressed(org.mkui.canvas.ElementalCanvasHandler.ElementalKeyEvent(it.keyCode))
                }
            }
        }

        canvas.onkeydown = {}

//                    final String key = event.getNativeEvent().getKeyCode()key;
//                    if(key != null) {
//                        int code = -1;
//                        switch (key) {
//                            case "ArrowDown":
//                                code = VK_DOWN;
//                                break;
//                            case "ArrowUp":
//                                code = VK_UP;
//                                break;
//                            case "PageDown":
//                                code = VK_PAGE_DOWN;
//                                break;
//                            case "PageUp":
//                                code = VK_PAGE_DOWN;
//                                break;
//                        }
//
//                        if(code >= 0) {
//                            l.keyPressed(new ElementalKeyEvent(code));
//                        }
//            }
//        }, KeyDownEvent.getType());
//        if(canvas != null) {
//            canvas.onkeydown = new elemental2.dom.Element.OnkeydownFn() {
//                @Override
//                public Object onInvoke(Event event) {
//                    GWTConsole.log("Receiving " + event);
//                    final String key = ((KeyboardEvent) event).key;
//                    if(key != null) {
//                        int code = -1;
//                        switch (key) {
//                            case "ArrowDown":
//                                code = VK_DOWN;
//                                break;
//                            case "ArrowUp":
//                                code = VK_UP;
//                                break;
//                            case "PageDown":
//                                code = VK_PAGE_DOWN;
//                                break;
//                            case "PageUp":
//                                code = VK_PAGE_DOWN;
//                                break;
//                        }
//
//                        if(code >= 0) {
//                            l.keyPressed(new ElementalKeyEvent(code));
//                        }
//                    }
//                    return null;
//                }
//            };
//
//            canvas.onkeyup = new elemental2.dom.Element.OnkeyupFn() {
//                @Override
//                public Object onInvoke(Event event) {
//                    GWTConsole.log("Receivingx " + event);
//                    l.keyReleased(new ElementalKeyEvent(-1));
//                    return null;
//                }
//            };
//        }
    }

    fun registerContextMenuListener() {
        if (nativeComponent != null) {
//            nativeComponent.sinkEvents(com.google.gwt.user.client.Event.ONCONTEXTMENU)
            canvas.oncontextmenu = {
                it.preventDefault()
                it.stopPropagation()
                for (l in contextMenuListeners) {
                    l.contextMenu(object : ContextMenuEvent {
                        override val x: Int
                            get() = it.clientX
                        override val y: Int
                            get() = it.clientY
                    })
                }
            }
        }
    }

    class ElementalMouseEvent(event: org.w3c.dom.events.MouseEvent, override val clickCount: Int) : MouseEvent {
        private val event: org.w3c.dom.events.MouseEvent

        // Possbily an alternative way to compute it irrespectively of the scale/transform
//                return (int) (event.clientX - currentTarget.clientX);
        override val x: Int
            get() = if (event.currentTarget != null && event.currentTarget !== event.target) {
                val currentTarget: HTMLElement = event.currentTarget!! as HTMLElement
                val target: Element = event.target!! as Element
                val scaleX: Double = currentTarget.getBoundingClientRect().width / currentTarget.offsetWidth
                ((target.getBoundingClientRect().left - currentTarget.getBoundingClientRect().left) / scaleX + event.offsetX)
                scaleX.toInt()
                // Possbily an alternative way to compute it irrespectively of the scale/transform
                //                return (int) (event.clientX - currentTarget.clientX);
            } else {
                event.offsetX.toInt()
            }

        // Possbily an alternative way to compute it irrespectively of the scale/transform
//                return (int) (event.clientY - currentTarget.clientY);
        override val y: Int
            get() {
                return if (event.currentTarget != null && event.currentTarget !== event.target) {
                    val currentTarget: HTMLElement = event.currentTarget!! as HTMLElement
                    val target: Element = event.target!! as Element
                    val scaleY: Double = currentTarget.getBoundingClientRect().height / currentTarget.offsetHeight
                    ((target.getBoundingClientRect().top - currentTarget.getBoundingClientRect().top) / scaleY + event.offsetY)
                    // Possbily an alternative way to compute it irrespectively of the scale/transform
                    //                return (int) (event.clientY - currentTarget.clientY);
                    scaleY.toInt()
                } else {
                    event.offsetY.toInt()
                }
            }

        override val isMenuShortcutKeyDown: Boolean
            get() {
                return event.ctrlKey || event.metaKey
            }
        override val isAltKeyDown: Boolean
            get() = event.altKey
        override val isShiftKeyDown: Boolean
            get() = event.shiftKey
        override val isMultipleSelectionKey: Boolean
            get() {
                return event.ctrlKey || event.metaKey
            }
        override val isPopupTrigger: Boolean
            get() = false
        override val isLeftMouseButton: Boolean
            get() = event.button == 0.toShort()
        override val isMiddleMouseButton: Boolean
            get() = event.button == 1.toShort()

        override fun stopPropagation() {
            event.stopPropagation()
        }

        init {
            this.event = event
        }
    }

    class ElementalKeyEvent(override val keyCode: Int) :
        KeyEvent //    public static class ElementalTouchEvent implements MouseEvent {

    //        private final elemental2.dom.TouchEvent event;
    //        private final int clickCount;
    //
    //        public ElementalTouchEvent(elemental2.dom.TouchEvent event, int clickCount) {
    //            this.event = event;
    //            this.clickCount = clickCount;
    //        }
    //
    //        @Override
    //        public int getX() {
    ////            Element relativeElem = event.getRelativeElement();
    ////            if (relativeElem != null) {
    ////                return getRelativeX(relativeElem);
    ////            }
    //            return event.getNativeEvent().getClientX();
    //        }
    //
    //        @Override
    //        public int getY() {
    //            Element relativeElem = event.getRelativeElement();
    //            if (relativeElem != null) {
    //                return getRelativeY(relativeElem);
    //            }
    //            return event.getNativeEvent().getClientY();
    //        }
    //
    //        public int getRelativeX(Element target) {
    //            NativeEvent e = event.getNativeEvent();
    //
    //            return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() +
    //                    target.getOwnerDocument().getScrollLeft();
    //        }
    //
    //        public int getRelativeY(Element target) {
    //            NativeEvent e = event.getNativeEvent();
    //
    //            return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() +
    //                    target.getOwnerDocument().getScrollTop();
    //        }
    //
    //        @Override
    //        public boolean isMenuShortcutKeyDown() {
    //            boolean ctrlOrMeta = event.getNativeEvent().getCtrlKey() || event.getNativeEvent().getMetaKey();
    //            return ctrlOrMeta;
    //        }
    //
    //        @Override
    //        public boolean isAltKeyDown() {
    //            return event.getNativeEvent().getAltKey();
    //        }
    //
    //        @Override
    //        public boolean isShiftKeyDown() {
    //            return event.getNativeEvent().getShiftKey();
    //        }
    //
    //        @Override
    //        public boolean isMultipleSelectionKey() {
    //            boolean ctrlOrMeta = event.getNativeEvent().getCtrlKey() || event.getNativeEvent().getMetaKey();
    //            return ctrlOrMeta;
    //        }
    //
    //        @Override
    //        public boolean isPopupTrigger() {
    //            return false;
    //        }
    //
    //        @Override
    //        public boolean isLeftMouseButton() {
    //            return event.getNativeEvent().getButton() == NativeEvent.BUTTON_LEFT;
    //        }
    //
    //        @Override
    //        public boolean isMiddleMouseButton() {
    //            return event.getNativeEvent().getButton() == NativeEvent.BUTTON_MIDDLE;
    //        }
    //
    //        @Override
    //        public void stopPropagation() {
    //            event.stopPropagation();
    //        }
    //
    //        @Override
    //        public int getClickCount() {
    //            return clickCount;
    //        }
    //    }

}
