package org.mkui.canvas

class JSMouseEvent(private val event: org.w3c.dom.events.MouseEvent, override val clickCount: Int) : MouseEvent {
    override val x: Int
        get() = event.offsetX.toInt()
    override val y: Int
        get() = event.offsetY.toInt()
    override val isMenuShortcutKeyDown: Boolean
        get() = event.ctrlKey || event.metaKey
    override val isMultipleSelectionKey: Boolean
        get() = event.ctrlKey || event.metaKey
    override val isAltKeyDown: Boolean
        get() = event.altKey
    override val isShiftKeyDown: Boolean
        get() = event.shiftKey
    override val isPopupTrigger: Boolean
        get() = false
    override val isLeftMouseButton: Boolean
        get() = event.button == 0.toShort()
    override val isMiddleMouseButton: Boolean
        get() = event.button == 1.toShort()

    override fun stopPropagation() {
        event.stopPropagation()
    }
}