package org.mkui.canvas

import org.mkui.graphics.CPGraphicsContext2D
import org.w3c.dom.CanvasRenderingContext2D
import org.w3c.dom.HTMLCanvasElement
import react.*
import react.dom.canvas
import react.dom.h1
import kotlinx.browser.window

const val HIDPI = true

external interface ReactCanvasProps : RProps {
    var graphicsContextDrawings: List<GraphicsContextDrawing>
}

external interface ReactCanvasState : RState {
}

class ReactCanvas() : RComponent<ReactCanvasProps, ReactCanvasState>() {
    private lateinit var resizeObserver: ResizeObserver

    var width = 0
    var height = 0
    var scaleFactor = 1.0
    var physicalWidth = 0
    var physicalHeight = 0

    private fun color(temperature: Double): String =
        "rgb(${(temperature + 20) * 2.56}, 0, ${(80 - temperature) * 2.56})"

    private fun findDesiredScaleFactor(): Double {
        return if (HIDPI)
            window.devicePixelRatio
        else
            1.0
    }

    fun dimensionHasChanged(width: Int, height: Int, scaleFactor: Double): Boolean {
        return this.width != width || this.height != height || this.scaleFactor != scaleFactor
    }

    fun syncCanvasDimension(width: Int, height: Int, scaleFactor: Double) {
        this.width = width
        this.height = height
        this.scaleFactor = scaleFactor
        this.physicalWidth = (width * scaleFactor).toInt()
        this.physicalHeight = (height * scaleFactor).toInt()
        val canvas = canvasRef.current
        if(canvas != null) {
            println("Resizing " + width + "x" + height + "@" + scaleFactor + " -> " + physicalWidth + "x" + physicalHeight)
            canvas.width = physicalWidth
            canvas.height = physicalHeight
            window.requestAnimationFrame { paintTheCanvas() }
        }
    }

    fun clearAndResetRenderingContext2D(g: CanvasRenderingContext2D) {
        // This seems like a hack, but works better because it reset the graphic context
//            canvas.setCoordinateSpaceWidth(canvas.getOffsetWidth());
        g.setTransform(scaleFactor, 0.0, 0.0, scaleFactor, 0.0, 0.0)
        g.clearRect(0.0, 0.0, width.toDouble(), height.toDouble())
    }

    private fun paintTheCanvas() {
        val temperature = 25.0
        val level = 0.5
        if (canvasRef.current != null) {
            with(ctx) {
//                val width = canvas.width.toDouble()
//                val height = canvas.height.toDouble()
                val width = canvas.clientWidth
                val height = canvas.clientHeight
                val scaleFactor = findDesiredScaleFactor()
                val dim = canvas.getBoundingClientRect()
                if(dimensionHasChanged(width, height, scaleFactor)) {
                    syncCanvasDimension(width, height, scaleFactor)
                }

                clearAndResetRenderingContext2D(ctx)
//                clearRect(0.0, 0.0, width.toDouble(), height.toDouble())
                lineWidth = 1.0
                fillStyle = color(temperature)
                fillRect(0.0, height * (1 - level / 2), width.toDouble(), height.toDouble())

//                for (i in graphicsContextDrawings) {
//                    i.draw(CPGraphicsContext2D(ctx), width.toDouble(), height.toDouble())
//                }
                for (i in props.graphicsContextDrawings) {
                    i.draw(CPGraphicsContext2D(ctx), width.toDouble(), height.toDouble())
                }
            }
        }
//        window.requestAnimationFrame { paintTheCanvas() }
    }

    override fun RBuilder.render() {
        canvas("canvas") {
//            css {
//                width = 100.pc
//                height = 100.pc
//            }

            ref = canvasRef
//            attrs.width = "100%"
//            attrs.height = "100%"
//            attrs.style = kotlinext.js.js {
//                height =  "100%"
//                width = "100%"
//            }
//            attrs.style = style {
//
//            }
//            attrs.style {
//                val height = "100%"
//                val width = "100%"
//            }
//            style {
//                val width = "100%"
//                val height = "100%"
//            }
        }
        h1 {
            +"This is a canvas!"
        }
        window.requestAnimationFrame { paintTheCanvas() }
    }

    override fun componentDidMount() {
        println("componentDidMount")
        val targetContainer = canvasRef.current!!
        resizeObserver = ResizeObserver { _, _ -> publishData(targetContainer) }
        resizeObserver.observe(targetContainer)
//        window.addEventListener("resize", publishData)
    }

    override fun componentWillUnmount() {
        println("componentWillUnmount")
//        window.removeEventListener("resize", publishData)
//        document.removeEventListener(DataChangeEvent.name, publishData)
        resizeObserver.disconnect()
    }

    private fun publishData(canvas: HTMLCanvasElement) {
        val width = canvas.clientWidth
        val height = canvas.clientHeight
        println("p " + width + "x" + height)
        val scaleFactor = findDesiredScaleFactor()
        val dim = canvas.getBoundingClientRect()
        if(dimensionHasChanged(width, height, scaleFactor)) {
            syncCanvasDimension(width, height, scaleFactor)
        }

    }

    private val canvasRef = createRef<HTMLCanvasElement>()

    private val ctx get() = canvasRef.current!!.getContext("2d") as CanvasRenderingContext2D
}

fun RBuilder.reactCanvas(handler: RHandler<ReactCanvasProps>) =
    child(ReactCanvas::class) {
        handler()
    }

fun RBuilder.reactCanvas2(handler: ReactCanvasProps.() -> Unit): ReactElement {
    return child(ReactCanvas::class) {
        this.attrs(handler)
    }
}

