package org.mkui.color

actual class CPColorFactory {
    actual companion object {
        actual val instance = CPColorFactory()
    }

    actual fun createNativeColor(color: Any?): CPColor? {
        return null
    }

    actual fun createColor(color: Int): CPColor {
        return CPColor(color)
    }

    actual fun createFloatRGBColor(r: Float, g: Float, b: Float): CPColor {
        return CPColor(r, g, b, 1.0f)
    }

    actual fun createRGBColor(r: Int, g: Int, b: Int): CPColor {
        return CPColor(r, g, b)
    }

    actual val white by lazy { CPColor(255u, 255u, 255u) }
    actual val lightGray by lazy { CPColor(192u, 192u, 192u) }
    actual val gray by lazy { CPColor(128u, 128u, 128u) }
    actual val darkGray by lazy { CPColor(64u,64u,64u) }
    actual val black by lazy { CPColor(0u, 0u, 0u) }
}