package org.mkui.font

actual class CPFontFactory {
    actual fun createFont(family: String?, style: Weight, size: Int): CPFont? {
        return CPFont(family!!, size.toDouble(), weight = style)
    }
    actual fun createFont(family: String?, style: Int, size: Int): CPFont? {
        return CPFont(family!!, size.toDouble())
    }

    actual fun decodeFont(labelingFont: String?): CPFont? {
        return CPFont(labelingFont!!, 12.0)
    }

    actual fun createFontFamily(family: String?): CPFont? {
        return CPFont(family!!, 12.0)
    }

    actual fun decodeFontWithDefault(
        labelingFont: String?,
        defaultLabelingFont: CPFont?
    ): CPFont? {
        val f: CPFont? = decodeFont(labelingFont)
        return if (f != null) {
            f
        } else {
            defaultLabelingFont
        }
    }

    actual fun createDefaultFont(): CPFont {
        return createFontFamily("Arial")!!
    }

    actual companion object {
        actual val instance: CPFontFactory = CPFontFactory()
    }

}