package org.mkui.window

import org.mkui.component.CPComponent
import react.*

external interface FunctionalReactWindowProps: RProps {
    var menu: CPComponent?
    var content: CPComponent?
}

val functionalWindow = functionalComponent<FunctionalReactWindowProps> { props ->
    val menu = props.menu
    if(menu != null) {
        child(menu.getNativeComponent())
    }

    val content = props.content
    if(content != null) {
        child(content.getNativeComponent())
    }
}

fun RBuilder.functionalWindow(handler: FunctionalReactWindowProps.() -> Unit): ReactElement {
    return child(functionalWindow) {
        this.attrs(handler)
    }
}
