package org.mkui.canvas

import com.macrofocus.common.collection.CollectionFactory
import org.mkui.color.CPColor
import org.mkui.component.CPComponent
import org.mkui.graphics.CPGraphicsContext2D
import org.mkui.graphics.GraphicsContext2D
import java.awt.Graphics
import java.awt.Graphics2D
import java.awt.event.ComponentEvent
import java.awt.event.ComponentListener
import java.awt.event.HierarchyEvent
import java.util.*
import javax.swing.JButton
import javax.swing.JComponent
import javax.swing.JPanel
import kotlin.collections.HashSet

actual open class CPCanvas : CPComponent {
    val graphics2DDrawings = CollectionFactory.copyOnWriteArrayList<org.mkui.canvas.Graphics2DDrawing>()

    private val listeners: MutableList<CanvasListener> = ArrayList()

    val canvas = CanvasComponent()
    val handler = org.mkui.canvas.SwingCanvasHandler(canvas)

    actual fun addLayer(d: GraphicsContextDrawing) {
        graphics2DDrawings.add(object : org.mkui.canvas.Graphics2DDrawing {
            override fun draw(g: Graphics2D, width: Double, height: Double) {
                d.draw(CPGraphicsContext2D(g), width, height)
            }
        })
    }

    fun addNativeLayer(d: org.mkui.canvas.Graphics2DDrawing) {
        graphics2DDrawings.add(d)
    }

    override val nativeComponent: JComponent
        get() = canvas

    inner class CanvasComponent() : JPanel() {
        private val dirtyLayers: MutableSet<GraphicsContextDrawing> = HashSet<GraphicsContextDrawing>()
//        protected val timer: CPTimer = SwingFactory.getInstance().createTimer("Canvas\$Prepare", 50, true, object : CPTimerListener() {
//            fun timerTriggered() {
//                prepare()
//            }
//        })

        override fun updateUI() {
            background = null
            super.updateUI()
//            updateColorTheme()
        }

//        private fun schedulePrepare(layer: SwingLayer) {
//            synchronized(dirtyLayers) { dirtyLayers.add(layer) }
//            if (isShowing) {
//                timer.restart()
//            }
//        }

        private fun schedulePrepare() {
            scheduleRender()
//            for (layer in layers) {
//                synchronized(dirtyLayers) { dirtyLayers.add(layer) }
//            }
//            if (isShowing) {
//                timer.restart()
//            }
        }

//        private fun prepare() {
//            prepareTiming.start()
//            val width = width
//            val height = height
//            var dirtyLayers: List<SwingLayer>
//            synchronized(this.dirtyLayers) {
//                dirtyLayers = ArrayList<Any?>(this.dirtyLayers)
//                this.dirtyLayers.clear()
//            }
//            for (layer in dirtyLayers) {
//                layer.prepare(width, height)
//            }
//            prepareTiming.end()
//            scheduleRender()
//        }
//
        fun scheduleRender() {
            repaint()
        }

        override fun paint(g: Graphics) {
//            renderTiming.start()
            if (isPaintingForPrint) {
//                prepare()
            }
            val g2 = g as Graphics2D
            g2.font = font
            for (layer in graphics2DDrawings) {
                layer.draw(g2, width.toDouble(), height.toDouble())
            }
//            val width = width.toDouble()
//            val height = height.toDouble()
//            renderTiming.end()
//            if (isShowTiming()) {
//                prepareTiming.draw(g2, Dimension(width.toInt(), height.toInt()), 32)
//                renderTiming.draw(g2, Dimension(width.toInt(), height.toInt()), 16)
//            }
        }

        init {
            isOpaque = false
            addComponentListener(object : ComponentListener {
                override fun componentResized(e: ComponentEvent) {
                    notifySizeChanged(width, height)
                    schedulePrepare()
                }

                override fun componentMoved(e: ComponentEvent) {}
                override fun componentShown(e: ComponentEvent) {}
                override fun componentHidden(e: ComponentEvent) {}
            })
            addHierarchyListener { e ->
                if (e.changeFlags and HierarchyEvent.SHOWING_CHANGED.toLong() != 0L) {
                    notifySizeChanged(width, height)
                    schedulePrepare()
                }
            }
            updateUI()
        }
    }

    actual open fun getWidth(): Double {
        return nativeComponent.width.toDouble()
    }

    actual open fun getHeight(): Double {
        return nativeComponent.height.toDouble()
    }

    actual open fun addCanvasListener(l: CanvasListener) {
        listeners.add(l)
    }

    protected open fun notifySizeChanged(width: Int, height: Int) {
        for (listener in listeners) {
            listener.sizeChange(width, height)
        }
    }

    actual fun redraw() {
        nativeComponent.repaint()
    }

    actual fun addMouseListener(l: MouseListener) {
        handler.addMouseListener(l)
    }

    actual open fun addMouseMotionListener(l: MouseMotionListener) {
        handler.addMouseMotionListener(l)
    }

    actual fun addMouseWheelListener(l: MouseWheelListener) {
        handler.addMouseWheelListener(l)
    }

    actual fun addKeyListener(l: KeyListener) {
        handler.addKeyListener(l)
    }

    actual fun addContextMenuListener(l: ContextMenuListener) {
        handler.addContextMenuListener(l)
    }
}