package org.mkui.canvas

import java.awt.event.KeyEvent
import java.awt.event.KeyListener
import java.awt.event.MouseEvent
import java.awt.event.MouseListener
import java.awt.event.MouseMotionListener
import java.util.*
import javax.swing.JComponent


class SwingCanvasHandler(private val canvas: JComponent) {
    private var popupTrigger = false
    private var keyListenerRegistered = false
    private var contextMenuListeners: MutableList<ContextMenuListener>? = null
    fun addMouseListener(l: org.mkui.canvas.MouseListener) {
        canvas.addMouseListener(object : MouseListener {
            override fun mouseClicked(e: MouseEvent) {
                if (popupTrigger && e.clickCount == 1) {
                    for (contextMenuListener in contextMenuListeners!!) {
                        val event: org.mkui.canvas.ContextMenuEvent = object : org.mkui.canvas.ContextMenuEvent {
                            override val x: Int
                                get() = e.x
                            override val y: Int
                                get() = e.y
                        }
                        contextMenuListener.contextMenu(event)
                    }
                } else {
                    l.mouseClicked(org.mkui.canvas.SwingMouseEvent(e))
                }
            }

            override fun mousePressed(e: MouseEvent) {
                popupTrigger = e.isPopupTrigger
                l.mousePressed(org.mkui.canvas.SwingMouseEvent(e))
            }

            override fun mouseReleased(e: MouseEvent) {
                if (!popupTrigger) {
                    popupTrigger = e.isPopupTrigger
                }
                l.mouseReleased(org.mkui.canvas.SwingMouseEvent(e))
            }

            override fun mouseEntered(e: MouseEvent) {
                if (keyListenerRegistered) {
                    canvas.requestFocusInWindow()
                }
                l.mouseEntered(org.mkui.canvas.SwingMouseEvent(e))
            }

            override fun mouseExited(e: MouseEvent) {
                l.mouseExited(org.mkui.canvas.SwingMouseEvent(e))
            }
        })
    }

    fun addMouseMotionListener(l: org.mkui.canvas.MouseMotionListener) {
        canvas.addMouseMotionListener(object : MouseMotionListener {
            override fun mouseDragged(e: MouseEvent) {
                l.mouseDragged(org.mkui.canvas.SwingMouseEvent(e))
            }

            override fun mouseMoved(e: MouseEvent) {
                l.mouseMoved(org.mkui.canvas.SwingMouseEvent(e))
            }
        })
    }

    fun addMouseWheelListener(l: org.mkui.canvas.MouseWheelListener) {
        canvas.addMouseWheelListener { e -> l.mouseWheelMoved(org.mkui.canvas.SwingMouseWheelEvent(e)) }
    }

    fun addKeyListener(l: org.mkui.canvas.KeyListener) {
        keyListenerRegistered = true
        canvas.addKeyListener(object : KeyListener {
            override fun keyTyped(e: KeyEvent) {
                l.keyTyped(org.mkui.canvas.SwingKeyEvent(e))
            }

            override fun keyPressed(e: KeyEvent) {
                l.keyPressed(org.mkui.canvas.SwingKeyEvent(e))
            }

            override fun keyReleased(e: KeyEvent) {
                l.keyReleased(org.mkui.canvas.SwingKeyEvent(e))
            }
        })
    }

    fun addContextMenuListener(l: ContextMenuListener) {
        if (contextMenuListeners == null) {
            contextMenuListeners = ArrayList()
        }
        contextMenuListeners!!.add(l)
    }
}
