package org.mkui.canvas

import org.mkui.text.CPTextMetrics
import java.awt.FontMetrics
import java.awt.Graphics2D

class SwingTextMetrics(val context: Graphics2D, val text: String?) : CPTextMetrics {
    private var fontMetrics: FontMetrics = context.fontMetrics

    override fun getWidth(): Double {
        return fontMetrics.getStringBounds(text, context).width
    }

    override fun getAscent(): Double {
        return fontMetrics.ascent.toDouble()
    }

}