package org.mkui.color

import java.awt.Color

actual class CPColorFactory {
    actual companion object {
        actual val instance = CPColorFactory()
    }

    actual fun createNativeColor(color: Any?): org.mkui.color.CPColor? {
        return if (color is Color) {
            org.mkui.color.CPColor(color)
        } else {
            null
        }
    }

    actual fun createColor(color: Int): org.mkui.color.CPColor {
        return org.mkui.color.CPColor(color)
    }

    actual fun createFloatRGBColor(r: Float, g: Float, b: Float): org.mkui.color.CPColor {
        return org.mkui.color.CPColor(r, g, b, 1.0f)
    }

    actual fun createRGBColor(r: Int, g: Int, b: Int): org.mkui.color.CPColor {
        return org.mkui.color.CPColor(r, g, b)
    }

    actual val white by lazy { org.mkui.color.CPColor(255u, 255u, 255u) }
    actual val lightGray by lazy { org.mkui.color.CPColor(192u, 192u, 192u) }
    actual val gray by lazy { org.mkui.color.CPColor(128u, 128u, 128u) }
    actual val darkGray by lazy { org.mkui.color.CPColor(64u, 64u, 64u) }
    actual val black by lazy { org.mkui.color.CPColor(0u, 0u, 0u) }

    val orange by lazy { org.mkui.color.CPColor(Color.ORANGE) }
    val purple by lazy { org.mkui.color.CPColor(128u, 0u, 128u) }
    val red by lazy { org.mkui.color.CPColor(Color.RED) }
}