package org.mkui.component

import com.macrofocus.common.properties.SimpleProperty
import org.mkui.component.CPComponent
import org.mkui.component.label.CPLabel
import org.mkui.component.panel.CPVerticalPanel
import javax.swing.*

fun mainFrame(title: String, build: JFrame.() -> Unit) = SwingUtilities.invokeAndWait {
    val frame = JFrame(title)
    build(frame)
    frame.defaultCloseOperation = WindowConstants.EXIT_ON_CLOSE
    frame.pack()
    frame.setSize(1000, 720)
    frame.setLocationRelativeTo(null)
    frame.isLocationByPlatform = true
    frame.isVisible = true
    frame.toFront()
}

actual class DefaultComponentFactory : ComponentFactory {
    override fun verticalPanel(build: VerticalPanelBuilder.() -> Unit): CPVerticalPanel {
        val component = CPVerticalPanel()
        build(DefaultVerticalPanelBuilder(component))
        return component
    }

    override fun label(label: String, build: (CPLabel.() -> Unit)?): CPLabel {
        val component = CPLabel(SimpleProperty(label))
        if (build != null) build(component)
        return component
    }
//
//    override fun button(onClick: () -> Unit, label: String, build: (CPButton.() -> Unit)?): CPButton {
//        val component = CPButton(onClick, SimpleProperty(label))
//        if (build != null) build(component)
//        return component
//    }
}