package org.mkui.component.menu

import com.macrofocus.common.command.ToggleUICommand
import javax.swing.JRadioButtonMenuItem
import com.macrofocus.common.properties.PropertyEvent
import com.macrofocus.common.properties.PropertyListener
import java.awt.event.ActionListener

class SwingRadioButtonMenuItem(private val command: ToggleUICommand) {
    val nativeComponent: JRadioButtonMenuItem = JRadioButtonMenuItem(command.titleProperty()!!.value)

    private val titleListener: PropertyListener<String?> = object : PropertyListener<String?> {
        override fun propertyChanged(event: PropertyEvent<String?>) {
            nativeComponent.text = event.newValue
        }
    }
    private val enabledListener: PropertyListener<Boolean?> = object : PropertyListener<Boolean?> {
        override fun propertyChanged(event: PropertyEvent<Boolean?>) {
            nativeComponent.isEnabled = event.newValue!!
        }
    }
    private val toggleListener: PropertyListener<Boolean> = object : PropertyListener<Boolean> {
        override fun propertyChanged(event: PropertyEvent<Boolean>) {
            nativeComponent.isSelected = event.newValue
        }
    }
    private val actionListener = ActionListener { e ->
        command.execute(e.source)
        command.toggleProperty().value = true
    }

    init {
        command.titleProperty()!!.addPropertyListener(titleListener)
        //        menuItem.setAccelerator(KeyStroke.getKeyStroke(command.keystrokeProperty().getValue()));
//        command.keystrokeProperty().addWeakPropertyListener(new PropertyListener<String>() {
//            @Override
//            public void propertyChanged(PropertyEvent<String> event) {
//                menuItem.setAccelerator(KeyStroke.getKeyStroke(event.getNewValue()));
//            }
//        });
        nativeComponent.isEnabled = command.enabledProperty()!!.value!! && command != null
        command.enabledProperty()!!.addPropertyListener(enabledListener)
        nativeComponent.addActionListener(actionListener)
        nativeComponent.isSelected = command.toggleProperty().value
        command.toggleProperty().addPropertyListener(toggleListener)
    }
}