package org.mkui.font

import java.awt.Font
import javax.swing.JLabel
import javax.swing.UIManager

actual class CPFontFactory {
    actual fun createFont(family: String?, style: Weight, size: Int): CPFont? {
        TODO("Not yet implemented")
    }

    actual fun createFont(family: String?, style: Int, size: Int): CPFont? {
        val font = Font.decode(family)
        return if (font != null) {
            CPFont(font.deriveFont(style, size.toFloat()))
        } else {
            null
        }
    }

    actual fun decodeFont(labelingFont: String?): CPFont? {
        var fontName: String = labelingFont!!
        var styleName = ""
        var fontSize = 12
        var fontStyle: Int = Font.PLAIN

        if (labelingFont == null) {
            return null
        }

        val lastHyphen: Int = labelingFont.lastIndexOf('-')
        val lastSpace: Int = labelingFont.lastIndexOf(' ')
        val sepChar = if (lastHyphen > lastSpace) '-' else ' '
        var sizeIndex: Int = labelingFont.lastIndexOf(sepChar)
        var styleIndex: Int = labelingFont.lastIndexOf(sepChar, sizeIndex - 1)
        val strlen: Int = labelingFont.length

        if (sizeIndex > 0 && sizeIndex + 1 < strlen) {
            try {
                fontSize = Integer.valueOf(labelingFont.substring(sizeIndex + 1)).toInt()
                if (fontSize <= 0) {
                    fontSize = 12
                }
            } catch (e: NumberFormatException) {
                /* It wasn't a valid size, if we didn't also find the
                 * start of the style string perhaps this is the style */
                styleIndex = sizeIndex
                sizeIndex = strlen
                if (labelingFont.get(sizeIndex - 1) == sepChar) {
                    sizeIndex--
                }
            }
        }

        if (styleIndex >= 0 && styleIndex + 1 < strlen) {
            styleName = labelingFont.substring(styleIndex + 1, sizeIndex)
            styleName = styleName.toLowerCase()
            if (styleName == "bolditalic") {
                fontStyle = Font.BOLD or Font.ITALIC
            } else if (styleName == "italic") {
                fontStyle = Font.ITALIC
            } else if (styleName == "bold") {
                fontStyle = Font.BOLD
            } else if (styleName == "plain") {
                fontStyle = Font.PLAIN
            } else {
                /* this string isn't any of the expected styles, so
                 * assume its part of the font name
                 */
                styleIndex = sizeIndex
                if (labelingFont.get(styleIndex - 1) == sepChar) {
                    styleIndex--
                }
            }
            fontName = labelingFont.substring(0, styleIndex)
        } else {
            var fontEnd = strlen
            if (styleIndex > 0) {
                fontEnd = styleIndex
            } else if (sizeIndex > 0) {
                fontEnd = sizeIndex
            }
            if (fontEnd > 0 && labelingFont.get(fontEnd - 1) == sepChar) {
                fontEnd--
            }
            fontName = labelingFont.substring(0, fontEnd)
        }
        return createFont(fontName, fontStyle, fontSize)
    }

    actual fun createFontFamily(family: String?): CPFont? {
        val font = Font.decode(family)
        return CPFont(font)
    }

    actual fun decodeFontWithDefault(
        labelingFont: String?,
        defaultLabelingFont: CPFont?
    ): CPFont? {
        val f: CPFont? = decodeFont(labelingFont)
        return if (f != null) {
            f
        } else {
            defaultLabelingFont
        }
    }

    actual fun createDefaultFont(): CPFont {
        var font = UIManager.getDefaults().getFont("Label.font")
        if (font == null) {
            font = JLabel().font
        }

        return CPFont(font)    }

    actual companion object {
        actual val instance: CPFontFactory = CPFontFactory()
    }

}