package org.mkui.graphics

import java.awt.Graphics2D
import java.awt.Transparency
import java.awt.image.BufferedImage
import java.awt.image.WritableRaster

actual class CPImage : Image {
    private var image: BufferedImage? = null
    private var raster: WritableRaster? = null

    private var physicalWidth = 0
    private var physicalHeight = 0
    private var scaleFactor = 0.0

    actual constructor(width: Int, height: Int) {
        scaleFactor = findCurrentScaleFactor(null)

        physicalWidth = Math.floor(width * scaleFactor).toInt()
        physicalHeight = Math.floor(height * scaleFactor).toInt()

        image = BufferedImage(physicalWidth, physicalHeight, BufferedImage.TYPE_INT_ARGB)
        raster = image!!.raster
    }

    constructor(g2: Graphics2D?, width: Int, height: Int) {
        scaleFactor = findCurrentScaleFactor(g2)

        physicalWidth = Math.floor(width * scaleFactor).toInt()
        physicalHeight = Math.floor(height * scaleFactor).toInt()

        val gc = g2?.deviceConfiguration
        image = if (gc != null) {
            gc.createCompatibleImage(physicalWidth, physicalHeight, Transparency.TRANSLUCENT)
        } else {
            BufferedImage(physicalWidth, physicalHeight, BufferedImage.TYPE_INT_ARGB)
        }
        raster = image!!.getRaster()
    }

    constructor(image: BufferedImage) {
        this.image = image
        raster = image.raster
    }

    override val width: Int
        get() = image!!.width
    override val height: Int
        get() = image!!.height

    override fun setPixels(x: Int, y: Int, w: Int, h: Int, iArray: IntArray?) {
        raster!!.setPixels(x, y, w, h, iArray)
    }

    override val isOneSamplePerArrayElement: Boolean = true
    override val isLoaded: Boolean = true

    override fun flush() {
        if (image != null) {
            image!!.flush()
        }
        image = null
        raster = null
    }

    override val nativeImage: java.awt.Image
        get() = image!!

    fun createGraphics() : Graphics2D {
        return image!!.createGraphics()
    }

    fun getScaleFactor(): Double {
        return scaleFactor
    }

    fun findCurrentScaleFactor(g2: Graphics2D?): Double {
        return g2?.deviceConfiguration?.defaultTransform?.scaleX ?: 1.0
    }
}