package org.mkui.graphics

import org.mkui.geom.Shape
import java.awt.Rectangle
import java.awt.geom.AffineTransform
import java.awt.geom.PathIterator
import java.awt.geom.Point2D
import java.awt.geom.Rectangle2D


class GeometryShape(private val geometry: Shape) : java.awt.Shape {
    override fun getBounds(): Rectangle {
        val b: org.mkui.geom.Rectangle2D = geometry.bounds2D
        val width: Double = b.width
        val height: Double = b.height
        if (width < 0 || height < 0) {
            return Rectangle()
        }
        val x: Double = b.x
        val y: Double = b.y
        val x1 = Math.floor(x)
        val y1 = Math.floor(y)
        val x2 = Math.ceil(x + width)
        val y2 = Math.ceil(y + height)
        return Rectangle(
            x1.toInt(), y1.toInt(),
            (x2 - x1).toInt(), (y2 - y1).toInt()
        )
    }

    override fun getBounds2D(): Rectangle2D {
        val b: org.mkui.geom.Rectangle2D = geometry.bounds2D
        return Rectangle2D.Double(b.x, b.y, b.width, b.height)
    }

    override fun contains(x: Double, y: Double): Boolean {
        return geometry.contains(org.mkui.geom.Point2D.Double(x, y))
    }

    override fun contains(p: Point2D): Boolean {
        return geometry.contains(org.mkui.geom.Point2D.Double(p.x, p.y))
    }

    override fun intersects(x: Double, y: Double, w: Double, h: Double): Boolean {
        return geometry.intersects(org.mkui.geom.Rectangle2D.Double(x, y, w, h))
    }

    override fun intersects(r: Rectangle2D): Boolean {
        return geometry.intersects(org.mkui.geom.Rectangle2D.Double(r.x, r.y, r.width, r.height))
    }

    override fun contains(x: Double, y: Double, w: Double, h: Double): Boolean {
//        return geometry.contains(new com.macrofocus.igraphics.Rectangle2D.Double(x, y, w, h));
        return false
    }

    override fun contains(r: Rectangle2D): Boolean {
//        return geometry.contains(new com.macrofocus.igraphics.Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        return false
    }

    override fun getPathIterator(at: AffineTransform): PathIterator {
        return GeometryPathIterator(geometry.getPathIterator(null), at)
    }

    override fun getPathIterator(at: AffineTransform, flatness: Double): PathIterator {
        return GeometryPathIterator(geometry.getFlattenPathIterator(flatness), at)
    }

    private class GeometryPathIterator(pi: org.mkui.geom.PathIterator, transform: AffineTransform?) :
        PathIterator {
        private val pi: org.mkui.geom.PathIterator
        private val transform: AffineTransform?
        override fun getWindingRule(): Int {
            return pi.windingRule
        }

        override fun isDone(): Boolean {
            return pi.isDone
        }

        override fun next() {
            pi.next()
        }

        override fun currentSegment(coords: FloatArray): Int {
            val type: Int = pi.currentSegment(coords)
            transform?.transform(coords, 0, coords, 0, coords.size / 2)
            return type
        }

        override fun currentSegment(coords: DoubleArray): Int {
            val type: Int = pi.currentSegment(coords)
            transform?.transform(coords, 0, coords, 0, coords.size / 2)
            return type
        }

        init {
            this.pi = pi
            this.transform = transform
        }
    }
}
