package org.mkui.labeling

import java.awt.Rectangle
import javax.swing.plaf.basic.BasicHTML


/**
 * Created by luc on 26.04.17.
 */
class EnhancedJLabelRenderer : EnhancedJLabel {
    constructor(text: String?) : super(text) {}
    constructor(data: EnhancedLabel) : super(data) {}
    constructor() {}

    /**
     * Overridden for performance reasons.
     */
    override fun registerListener(data: EnhancedLabel) {}

    /**
     * Overridden for performance reasons.
     */
    override fun unregisterListener(data: EnhancedLabel?) {}

    /**
     * Overridden for performance reasons.
     * See the [Implementation Note](#override)
     * for more information.
     *
     * @since 1.5
     */
    override fun invalidate() {}

    /**
     * Overridden for performance reasons.
     * See the [Implementation Note](#override)
     * for more information.
     */
    override fun validate() {}

    /**
     * Overridden for performance reasons.
     * See the [Implementation Note](#override)
     * for more information.
     */
    override fun revalidate() {}

    /**
     * Overridden for performance reasons.
     * See the [Implementation Note](#override)
     * for more information.
     */
    override fun repaint(tm: Long, x: Int, y: Int, width: Int, height: Int) {}

    /**
     * Overridden for performance reasons.
     * See the [Implementation Note](#override)
     * for more information.
     */
    override fun repaint(r: Rectangle?) {}

    /**
     * Overridden for performance reasons.
     * See the [Implementation Note](#override)
     * for more information.
     *
     * @since 1.5
     */
    override fun repaint() {}

    /**
     * Overridden for performance reasons.
     * See the [Implementation Note](#override)
     * for more information.
     */
    override fun firePropertyChange(propertyName: String?, oldValue: Any?, newValue: Any?) {
        // Strings get interned...
        if (propertyName === "text"
            || ((propertyName === "font" || propertyName === "foreground")
                    && oldValue !== newValue && getClientProperty(BasicHTML.propertyKey) != null)
        ) {
            super.firePropertyChange(propertyName, oldValue, newValue)
        }
    }

    /**
     * Overridden for performance reasons.
     * See the [Implementation Note](#override)
     * for more information.
     */
    override fun firePropertyChange(propertyName: String?, oldValue: Boolean, newValue: Boolean) {}
}
