package org.mkui.swing

import com.macrofocus.common.selection.*
import java.awt.event.ItemEvent
import java.awt.event.ItemListener
import java.util.ArrayList
import java.util.HashSet
import javax.swing.*

open class HierarchicalComboBox<E>(val orientation: Orientation, val selection: MutableSelection<E>, val values: Iterable<E?>) : JPanel() {
    private val comboBoxes: MutableList<JComboBox<E>> = ArrayList<JComboBox<E>>()
    private val itemListener: GroupByItemListener = GroupByItemListener()

    init {
        layout = BoxLayout(this, if(orientation == Orientation.Vertical) BoxLayout.PAGE_AXIS else BoxLayout.LINE_AXIS)

        selection.addSelectionListener(object : SelectionListener<E> {
            override fun selectionChanged(event: SelectionEvent<E>) {
                createComboBoxes()
            }
        })

        createComboBoxes()
    }

    fun createComboBoxes() {
        for (comboBox in comboBoxes) {
            comboBox.removeItemListener(itemListener)
        }

        removeAll()
        comboBoxes.clear()


        val groupByTreeMapFields = selection
        for (e in groupByTreeMapFields) {
            val comboBox = createComboBox(e)
            comboBoxes.add(comboBox)
        }

        val lastComboBox = createComboBox(null)
        comboBoxes.add(lastComboBox)

        for (comboBox in comboBoxes) {
            add(comboBox)
            comboBox.addItemListener(itemListener)
        }

        invalidate()

        if (parent != null) {
            if (parent.parent != null) {
                if (parent.parent.parent != null) {
                    parent.parent.parent.validate()
                }
            } else {
                validate()
            }
        } else {
            validate()
        }
    }

    protected fun createComboBox(element: E?): JComboBox<E> {
        val selection: MutableSingleSelection<E> = if(element != null) SimpleSingleSelection(element) else SimpleSingleSelection()

        val comboBoxModel: ComboBoxModel<E?> = SingleSelectionComboBoxModel<E>(selection, values)
        val comboBox = createComboBox(comboBoxModel)
        //        comboBox.setStretchToFit(true)
//        comboBox.setRenderer(AttributeCellRenderer())
        return comboBox
    }

    protected fun createComboBox(comboBoxModel: ComboBoxModel<E?>): JComboBox<E> {
        val comboBox = JComboBox<E>(comboBoxModel)
        return comboBox
    }

    private inner class GroupByItemListener : ItemListener {
        override fun itemStateChanged(e: ItemEvent) {
            var groupBy = ArrayList<E>()
            val selected: MutableSet<E> = HashSet()
            for (comboBox in comboBoxes) {
                val item: E = comboBox.selectedItem as E
                if (item == null) {
                    break
                }

                // Make sure there is no duplicate
                if (selected.contains(item)) {
                    break
                } else {
                    selected.add(item)
                }
                groupBy.add(item)

                // Reset everything below the combobox where the change occured
                if (e.source === comboBox) {
                    break
                }
            }

            selection.setSelectedIterable(groupBy)
        }
    }
}