package org.mkui.swing

import javax.swing.DefaultComboBoxModel
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.PropertyEvent
import com.macrofocus.common.properties.PropertyListener
import javax.swing.event.ListDataListener
import javax.swing.event.ListDataEvent

/**
 * Adapter class for interfacing Selection with Swing's ComboBox.
 */
class PropertyComboBoxModel<E> : DefaultComboBoxModel<Any?> {
    constructor(selection: MutableProperty<E>, values: Iterable<E>) {
        for (value in values) {
            addElement(value)
        }
        init(selection)
    }

    constructor(selection: MutableProperty<E>, vararg values: E) {
        for (value in values) {
            addElement(value)
        }
        init(selection)
    }

    private fun init(property: MutableProperty<E>) {
        property.addPropertyListener(object : PropertyListener<E> {
            override fun propertyChanged(event: PropertyEvent<E>) {
                selectedItem = event.newValue
            }
        })
        selectedItem = property.value
        addListDataListener(object : ListDataListener {
            override fun intervalAdded(e: ListDataEvent) {}
            override fun intervalRemoved(e: ListDataEvent) {}
            override fun contentsChanged(e: ListDataEvent) {
                property.value = selectedItem as E
            }
        })
    }
}