package org.mkui.swing

import javax.swing.DefaultComboBoxModel
import com.macrofocus.common.selection.MutableSingleSelection
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.selection.SingleSelectionListener
import com.macrofocus.common.selection.SingleSelectionEvent
import javax.swing.event.ListDataListener
import javax.swing.event.ListDataEvent
import com.macrofocus.common.properties.PropertyEvent
import com.macrofocus.common.properties.PropertyListener

/**
 * Adapter class for interfacing Selection with Swing's ComboBox.
 */
class SingleSelectionComboBoxModel<E> : DefaultComboBoxModel<E?> {
    constructor(selection: MutableSingleSelection<E>, values: Iterable<E?>) {
        for (value in values) {
            addElement(value)
        }
        init(selection)
    }

    constructor(selection: MutableSingleSelection<E>, vararg values: E?) {
        for (value in values) {
            addElement(value)
        }
        init(selection)
    }

    constructor(selection: MutableProperty<E>, values: Iterable<E?>) {
        for (value in values) {
            addElement(value)
        }
        init(selection)
    }

    constructor(selection: MutableProperty<E>, vararg values: E) {
        for (value in values) {
            addElement(value)
        }
        init(selection)
    }

    private fun init(selection: MutableSingleSelection<E>) {
        selection.addSingleSelectionListener(object : SingleSelectionListener<E> {
            override fun selectionChanged(event: SingleSelectionEvent<E>) {
                selectedItem = event.currentSelection
            }
        })
        selectedItem = selection.selected
        addListDataListener(object : ListDataListener {
            override fun intervalAdded(e: ListDataEvent) {}
            override fun intervalRemoved(e: ListDataEvent) {}
            override fun contentsChanged(e: ListDataEvent) {
                selection.selected = selectedItem as E
            }
        })
    }

    private fun init(selection: MutableProperty<E>) {
        selection.addPropertyListener(object : PropertyListener<E> {
            override fun propertyChanged(event: PropertyEvent<E>) {
                selectedItem = event.newValue
            }
        })
        selectedItem = selection.value
        addListDataListener(object : ListDataListener {
            override fun intervalAdded(e: ListDataEvent) {}
            override fun intervalRemoved(e: ListDataEvent) {}
            override fun contentsChanged(e: ListDataEvent) {
                selection.value = selectedItem as E
            }
        })
    }
}