package org.mkui.window

import org.mkui.component.CPComponent
import java.awt.BorderLayout
import java.awt.Dimension
import javax.swing.JComponent
import javax.swing.JFrame
import javax.swing.JMenuBar
import javax.swing.JPanel

actual class CPWindow {
    fun getNativeComponent(): JComponent {
        return panel
    }

    fun setMenuBar(menuBar: JMenuBar) {
        nativeWindow.jMenuBar = menuBar
    }

    fun setStatusBar(statusBar: CPComponent) {
        panel.add(statusBar.nativeComponent, BorderLayout.SOUTH)
    }

    val nativeWindow : JFrame
    val panel : JPanel
    val component : CPComponent
    actual var content: CPComponent? = null
        set(value) {
            if(field != null) {
                panel.remove(field!!.nativeComponent)
            }

            field = value

            if(field!= null) {
                panel.add(field!!.nativeComponent)
            }

            panel.validate()
        }

    init {
        nativeWindow = JFrame()
        panel = JPanel()
        panel.layout = BorderLayout()
        component = object : CPComponent {
            override val nativeComponent: JComponent
                get() = panel
        }

        with(nativeWindow) {
            size = Dimension(1000, 720)
            setLocationRelativeTo(null)
            isLocationByPlatform = true
            isVisible = true
            toFront()
            requestFocus()

            with(contentPane) {
                contentPane.removeAll()
                contentPane.add(panel)
                contentPane.validate()
            }
        }
    }

    actual var menuBar: CPComponent?
        get() = null
        set(value) {nativeWindow.jMenuBar = value!!.nativeComponent as JMenuBar}
}
