package svgpanzoom

@JsModule("svg-pan-zoom")
@JsNonModule

external fun svgPanZoom(
    a: Any,
    options: options = definedExternally
) : SvgPanZoomContext

external interface SvgPanZoomContext {
    fun zoom(zoomScale: Double)

    fun center()

    /**
     * Zoom at point in SVG coordinates
     */
    fun zoomAtPoint(zoomScale: Double, point: dynamic, zoomAbsolute: Boolean = definedExternally)
    fun pan(point: dynamic)
    fun panBy(point: dynamic)
    fun getZoom(): Double
    fun getPan(): dynamic

    fun getSizes(): dynamic

    fun resetZoom()
    fun resetPan()
    fun reset()

    fun isDblClickZoomEnabled(): Boolean
}

@Suppress("ClassName")
external interface options {
    var viewportSelector: String? // Viewport selector. Can be querySelector string or SVGElement
        get() = definedExternally
        set(value) = definedExternally
    var panEnabled: Boolean? // enable or disable panning (default enabled)
        get() = definedExternally
        set(value) = definedExternally
    var controlIconsEnabled: Boolean? // insert icons to give user an option in addition to mouse events to control pan/zoom (default disabled)
        get() = definedExternally
        set(value) = definedExternally
    var zoomEnabled: Boolean? // enable or disable zooming (default enabled)
        get() = definedExternally
        set(value) = definedExternally
    var dblClickZoomEnabled: Boolean? // enable or disable zooming by double clicking (default enabled)
        get() = definedExternally
        set(value) = definedExternally
    var mouseWheelZoomEnabled: Boolean? // enable or disable zooming by mouse wheel (default enabled)
        get() = definedExternally
        set(value) = definedExternally
    var preventMouseEventsDefault: Boolean? // enable or disable preventDefault for mouse events
        get() = definedExternally
        set(value) = definedExternally
    var zoomScaleSensitivity: Double? // Zoom sensitivity
        get() = definedExternally
        set(value) = definedExternally
    var minZoom: Double? // Minimum Zoom level
        get() = definedExternally
        set(value) = definedExternally
    var maxZoom: Double? // Maximum Zoom level
        get() = definedExternally
        set(value) = definedExternally
    var fit: Boolean? // enable or disable viewport fit in SVG (default true)
        get() = definedExternally
        set(value) = definedExternally
    var contain: Boolean? // enable or disable viewport contain the svg (default false)
        get() = definedExternally
        set(value) = definedExternally
    var center: Boolean? // enable or disable viewport centering in SVG (default true)
        get() = definedExternally
        set(value) = definedExternally
    var refreshRate: String? // Maximum number of frames per second (altering SVG's viewport)
        get() = definedExternally
        set(value) = definedExternally
    var beforeZoom: Any?
        get() = definedExternally
        set(value) = definedExternally
    var onZoom: Any?
        get() = definedExternally
        set(value) = definedExternally
    var beforePan: Any?
        get() = definedExternally
        set(value) = definedExternally
    var onPan: Any?
        get() = definedExternally
        set(value) = definedExternally
    var customEventsHandler: Any?
        get() = definedExternally
        set(value) = definedExternally
    var eventsListenerElement: Any?
        get() = definedExternally
        set(value) = definedExternally
    var onUpdatedCTM: Any?
        get() = definedExternally
        set(value) = definedExternally
}

class DefaultOptions : options
