/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0018\u001a\u00020\u0019H\u0016J8\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/mkui/canvas/AbstractBufferedImageOp;", "Ljava/awt/image/BufferedImageOp;", "", "()V", "createCompatibleDestImage", "Ljava/awt/image/BufferedImage;", "src", "dstCM", "Ljava/awt/image/ColorModel;", "getBounds2D", "Ljava/awt/geom/Rectangle2D;", "getPoint2D", "Ljava/awt/geom/Point2D;", "srcPt", "dstPt", "getRGB", "", "image", "x", "", "y", "width", "height", "pixels", "getRenderingHints", "Ljava/awt/RenderingHints;", "setRGB", "", "mkui"})
@StabilityInferred(parameters=0)
public abstract class AbstractBufferedImageOp
implements BufferedImageOp,
Cloneable {
    public static final int $stable;

    @Override
    @NotNull
    public BufferedImage createCompatibleDestImage(@NotNull BufferedImage src, @NotNull ColorModel dstCM) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dstCM, (String)"dstCM");
        ColorModel dstCM2 = dstCM;
        return new BufferedImage(dstCM2, dstCM2.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), dstCM2.isAlphaPremultiplied(), null);
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D(@NotNull BufferedImage src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    @Override
    @NotNull
    public Point2D getPoint2D(@NotNull Point2D srcPt, @NotNull Point2D dstPt) {
        Intrinsics.checkNotNullParameter((Object)srcPt, (String)"srcPt");
        Intrinsics.checkNotNullParameter((Object)dstPt, (String)"dstPt");
        Point2D dstPt2 = dstPt;
        dstPt2.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt2;
    }

    @Override
    @NotNull
    public RenderingHints getRenderingHints() {
        return new RenderingHints(null);
    }

    @NotNull
    public final int[] getRGB(@NotNull BufferedImage image, int x, int y, int width, int height, @Nullable int[] pixels) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int type = image.getType();
        switch (type) {
            case 1: 
            case 2: {
                Object object = image.getRaster().getDataElements(x, y, width, height, pixels);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.IntArray");
                nArray = (int[])object;
                break;
            }
            default: {
                int[] nArray2 = image.getRGB(x, y, width, height, pixels, 0, width);
                nArray = nArray2;
                Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"image.getRGB(x, y, width\u2026height, pixels, 0, width)");
            }
        }
        return nArray;
    }

    public final void setRGB(@NotNull BufferedImage image, int x, int y, int width, int height, @Nullable int[] pixels) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int type = image.getType();
        switch (type) {
            case 1: 
            case 2: {
                image.getRaster().setDataElements(x, y, width, height, pixels);
                break;
            }
            default: {
                image.setRGB(x, y, width, height, pixels, 0, width);
            }
        }
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }
}

