/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.ImageInfo;
import org.mkui.canvas.DirectSwingLayer;
import org.mkui.canvas.DrawScopeLayer;
import org.mkui.canvas.PaletteProvider;
import org.mkui.color.MkColor;
import org.mkui.graphics.IDrawing;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/mkui/canvas/BufferedSwingLayer;", "Lorg/mkui/canvas/DrawScopeLayer;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "antialiasing", "", "paletteProvider", "Lorg/mkui/canvas/PaletteProvider;", "(Lorg/mkui/graphics/IDrawing;ZLorg/mkui/canvas/PaletteProvider;)V", "(Lorg/mkui/graphics/IDrawing;Z)V", "color", "Lorg/mkui/color/MkColor;", "composite", "Ljava/awt/Composite;", "(Lorg/mkui/graphics/IDrawing;ZLorg/mkui/color/MkColor;Ljava/awt/Composite;)V", "height", "", "image", "Ljava/awt/image/BufferedImage;", "screenImage", "width", "clear", "", "prepare", "render", "g", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "resize", "Companion", "mkui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBufferedSwingLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedSwingLayer.kt\norg/mkui/canvas/BufferedSwingLayer\n+ 2 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n*L\n1#1,118:1\n245#2:119\n*S KotlinDebug\n*F\n+ 1 BufferedSwingLayer.kt\norg/mkui/canvas/BufferedSwingLayer\n*L\n85#1:119\n*E\n"})
public final class BufferedSwingLayer
implements DrawScopeLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    @Nullable
    private PaletteProvider paletteProvider;
    @Nullable
    private MkColor color;
    @Nullable
    private Composite composite;
    private int width;
    private int height;
    @Nullable
    private BufferedImage image;
    @Nullable
    private BufferedImage screenImage;
    public static final int $stable = 8;

    public BufferedSwingLayer(@NotNull IDrawing iDrawing, boolean antialiasing, @Nullable PaletteProvider paletteProvider) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.paletteProvider = paletteProvider;
    }

    public BufferedSwingLayer(@NotNull IDrawing iDrawing, boolean antialiasing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
    }

    public BufferedSwingLayer(@NotNull IDrawing iDrawing, boolean antialiasing, @NotNull MkColor color, @Nullable Composite composite) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.color = color;
        this.composite = composite;
    }

    @Override
    public void prepare(int width, int height) {
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.resize(width, height);
            BufferedImage bufferedImage = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"image!!.createGraphics()");
            Graphics2D g2 = graphics2D;
            DirectSwingLayer.Companion.draw(g2, this.iDrawing, this.width, this.height, this.antialiasing, this.paletteProvider, this.color, this.composite);
            g2.dispose();
            BufferedImage bufferedImage2 = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage2);
            BufferedImage bufferedImage3 = this.screenImage;
            Intrinsics.checkNotNull((Object)bufferedImage3);
            BufferedSwingLayer.Companion.copySrcIntoDstAt(bufferedImage2, bufferedImage3);
        }
    }

    public final void resize(int width, int height) {
        if (this.width != width || this.height != height) {
            this.image = new BufferedImage(width, height, 2);
            this.screenImage = new BufferedImage(width, height, 2);
            this.width = width;
            this.height = height;
        } else {
            this.clear();
        }
    }

    public final void clear() {
        if (this.image != null) {
            BufferedImage bufferedImage = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"image!!.createGraphics()");
            Graphics2D g2 = graphics2D;
            g2.setComposite(AlphaComposite.Clear);
            g2.setColor(new Color(255, 255, 255, 0));
            BufferedImage bufferedImage2 = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage2);
            int n = bufferedImage2.getWidth();
            BufferedImage bufferedImage3 = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage3);
            g2.fillRect(0, 0, n, bufferedImage3.getHeight());
            g2.dispose();
        }
    }

    @Override
    public void render(@Nullable DrawScope g2) {
        block2: {
            if (!this.iDrawing.isActive() || this.image == null) break block2;
            DrawScope drawScope = g2;
            if (drawScope != null) {
                DrawScope $this$drawIntoCanvas$iv = drawScope;
                boolean $i$f$drawIntoCanvas = false;
                androidx.compose.ui.graphics.Canvas it = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
                boolean bl = false;
                Canvas canvas2 = SkiaBackedCanvas_skikoKt.getNativeCanvas((androidx.compose.ui.graphics.Canvas)it);
                if (canvas2 != null) {
                    BufferedImage bufferedImage = this.screenImage;
                    Intrinsics.checkNotNull((Object)bufferedImage);
                    org.jetbrains.skia.Image image = Companion.convertToSkijaImage(bufferedImage);
                    Intrinsics.checkNotNull((Object)image);
                    canvas2.drawImage(image, 0.0f, 0.0f);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/mkui/canvas/BufferedSwingLayer$Companion;", "", "()V", "convertToSkijaImage", "Lorg/jetbrains/skia/Image;", "image", "Ljava/awt/Image;", "copySrcIntoDstAt", "", "src", "Ljava/awt/image/BufferedImage;", "dst", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        private final void copySrcIntoDstAt(BufferedImage src, BufferedImage dst) {
            DataBuffer dataBuffer = src.getRaster().getDataBuffer();
            Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"src.raster.dataBuffer as DataBufferInt).data");
            int[] srcbuf = nArray;
            DataBuffer dataBuffer2 = dst.getRaster().getDataBuffer();
            Intrinsics.checkNotNull((Object)dataBuffer2, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
            int[] nArray2 = ((DataBufferInt)dataBuffer2).getData();
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"dst.raster.dataBuffer as DataBufferInt).data");
            int[] dstbuf = nArray2;
            System.arraycopy(srcbuf, 0, dstbuf, 0, srcbuf.length);
        }

        @Nullable
        public final org.jetbrains.skia.Image convertToSkijaImage(@NotNull Image image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            BufferedImage img = new BufferedImage(w, h, 2);
            Graphics2D g2 = img.createGraphics();
            g2.drawImage(image, 0, 0, null);
            DataBuffer dataBuffer = img.getRaster().getDataBuffer();
            Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
            DataBufferInt db = (DataBufferInt)dataBuffer;
            int[] pixels = db.getData();
            byte[] bytes = new byte[pixels.length * 4];
            for (int p : pixels) {
                bytes[i * 4 + 3] = (byte)((p & 0xFF000000) >> 24);
                bytes[i * 4 + 2] = (byte)((p & 0xFF0000) >> 16);
                bytes[i * 4 + 1] = (byte)((p & 0xFF00) >> 8);
                bytes[i * 4] = (byte)(p & 0xFF);
            }
            ImageInfo imageInfo = new ImageInfo(w, h, ColorType.BGRA_8888, ColorAlphaType.PREMUL);
            return org.jetbrains.skia.Image.Companion.makeRaster(imageInfo, bytes, image.getWidth(null) * 4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

