/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import java.awt.AlphaComposite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.BufferedSwingLayer;
import org.mkui.canvas.CanvasListener;
import org.mkui.canvas.ContextMenuListener;
import org.mkui.canvas.DensitySwingLayer;
import org.mkui.canvas.DirectSwingLayer;
import org.mkui.canvas.DrawScopeLayer;
import org.mkui.canvas.FunctionalCPCanvas;
import org.mkui.canvas.GraphicsContextDrawing;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.component.CPInteractiveComponent;
import org.mkui.graphics.CPGraphicsContext2D;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IDrawingListener;
import org.mkui.graphics.pressure.Pressure;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u001e\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\tH\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0011H\u0016J\u000e\u0010%\u001a\u00020\u00142\u0006\u0010$\u001a\u00020&J.\u0010'\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u000e\u0010,\u001a\u00020\u00142\u0006\u0010$\u001a\u00020-J\u000e\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u000200J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\tH\u0016J\u0010\u00101\u001a\u00020\u00142\u0006\u0010$\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00142\u0006\u0010$\u001a\u000204H\u0016J\u000e\u00105\u001a\u00020\u00142\u0006\u0010$\u001a\u000206J\u000e\u00107\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\rJ\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u000209H\u0016J\u0018\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=H\u0014J\u0006\u0010?\u001a\u00020\u0014J\u0006\u0010@\u001a\u00020\u0014J\u0018\u0010A\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\nH\u0002J\b\u0010D\u001a\u00020\u0014H\u0016J\u0010\u0010E\u001a\u00020\u00142\u0006\u0010$\u001a\u000202H\u0016J\u0010\u0010F\u001a\u00020\u00142\u0006\u0010$\u001a\u000204H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0012\u001a\r\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\b\u00158VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006G"}, d2={"Lorg/mkui/canvas/CPCanvas;", "Lorg/mkui/component/CPInteractiveComponent;", "()V", "canvas", "Lorg/mkui/canvas/FunctionalCPCanvas;", "getCanvas", "()Lorg/mkui/canvas/FunctionalCPCanvas;", "drawings", "", "Lorg/mkui/graphics/IDrawing;", "Lorg/mkui/graphics/IDrawingListener;", "layers", "", "Lorg/mkui/canvas/DrawScopeLayer;", "getLayers", "()Ljava/util/List;", "listeners", "Lorg/mkui/canvas/CanvasListener;", "nativeComponent", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "getNativeComponent$annotations", "getNativeComponent", "()Lkotlin/jvm/functions/Function2;", "showTiming", "Lcom/macrofocus/common/properties/MutableProperty;", "", "getShowTiming", "()Lcom/macrofocus/common/properties/MutableProperty;", "addAveragingLayer", "rendering", "Lorg/mkui/canvas/Rendering;", "iDrawing", "addBufferedLayer", "addCanvasListener", "l", "addContextMenuListener", "Lorg/mkui/canvas/ContextMenuListener;", "addDensityLayer", "pressure", "Lorg/mkui/graphics/pressure/Pressure;", "paletteProvider", "Lorg/mkui/canvas/PaletteProvider;", "addKeyListener", "Lorg/mkui/canvas/KeyListener;", "addLayer", "d", "Lorg/mkui/canvas/GraphicsContextDrawing;", "addMouseListener", "Lorg/mkui/canvas/MouseListener;", "addMouseMotionListener", "Lorg/mkui/canvas/MouseMotionListener;", "addMouseWheelListener", "Lorg/mkui/canvas/MouseWheelListener;", "addNativeLayer", "getHeight", "", "getWidth", "notifySizeChanged", "width", "", "height", "redraw", "refresh", "registerDrawing", "drawing", "listener", "removeAllLayers", "removeMouseListener", "removeMouseMotionListener", "mkui"})
@StabilityInferred(parameters=0)
public class CPCanvas
implements CPInteractiveComponent {
    @NotNull
    private final List<DrawScopeLayer> layers = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    @NotNull
    private final Map<IDrawing, IDrawingListener> drawings = CollectionFactory.INSTANCE.concurrentHashMap();
    @NotNull
    private final List<CanvasListener> listeners = new ArrayList();
    @NotNull
    private final MutableProperty<Boolean> showTiming = (MutableProperty)new SimpleProperty((Object)false);
    @NotNull
    private final FunctionalCPCanvas canvas = new FunctionalCPCanvas(this.layers, this.listeners, this.showTiming);
    public static final int $stable = 8;

    @NotNull
    public final List<DrawScopeLayer> getLayers() {
        return this.layers;
    }

    @NotNull
    public final MutableProperty<Boolean> getShowTiming() {
        return this.showTiming;
    }

    @NotNull
    public final FunctionalCPCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    @NotNull
    public Function2<Composer, Integer, Unit> getNativeComponent() {
        return this.canvas.getNativeComponent();
    }

    public static /* synthetic */ void getNativeComponent$annotations() {
    }

    public final void addLayer(@NotNull GraphicsContextDrawing d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(new DrawScopeLayer(d, this){
            final /* synthetic */ GraphicsContextDrawing $d;
            final /* synthetic */ CPCanvas this$0;
            {
                this.$d = $d;
                this.this$0 = $receiver;
            }

            public void prepare(int width, int height) {
            }

            public void render(@Nullable DrawScope g2) {
                DrawScope drawScope = g2;
                Intrinsics.checkNotNull((Object)drawScope);
                this.$d.draw(new CPGraphicsContext2D(drawScope), this.this$0.getWidth(), this.this$0.getHeight());
            }
        });
    }

    public void addDensityLayer(@Nullable Rendering rendering, @NotNull IDrawing iDrawing, @Nullable Pressure pressure, @Nullable PaletteProvider paletteProvider) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        DrawScopeLayer layer = null;
        Rendering rendering2 = rendering;
        switch (rendering2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering2.ordinal()]) {
            case 1: {
                Pressure pressure2 = pressure;
                Intrinsics.checkNotNull((Object)pressure2);
                PaletteProvider paletteProvider2 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider2);
                layer = new DensitySwingLayer(iDrawing, 0, 0, true, pressure2, paletteProvider2);
                this.layers.add(layer);
                break;
            }
            case 2: {
                float alpha = 0.5f;
                PaletteProvider paletteProvider3 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider3);
                layer = new BufferedSwingLayer(iDrawing, true, paletteProvider3.getPalette().getColor(1.0), AlphaComposite.getInstance(3, alpha));
                this.layers.add(layer);
                break;
            }
            case 3: {
                PaletteProvider paletteProvider4 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider4);
                layer = new BufferedSwingLayer(iDrawing, true, paletteProvider4.getPalette().getColor(1.0), null);
                this.layers.add(layer);
                break;
            }
            case 4: {
                PaletteProvider paletteProvider5 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider5);
                layer = new DirectSwingLayer(iDrawing, paletteProvider5.getPalette().getColor(1.0));
                this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(this, layer){
            final /* synthetic */ CPCanvas this$0;
            final /* synthetic */ DrawScopeLayer $layer;
            {
                this.this$0 = $receiver;
                this.$layer = $layer;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().schedulePrepare(this.$layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addAveragingLayer(@Nullable Rendering rendering, @NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
    }

    public final void addNativeLayer(@NotNull DrawScopeLayer d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(d);
    }

    public void addLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
    }

    public void addBufferedLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
    }

    private final void registerDrawing(IDrawing drawing, IDrawingListener listener2) {
        this.drawings.put(drawing, listener2);
        drawing.addIDrawingListener(listener2);
    }

    public void removeAllLayers() {
        this.layers.clear();
        for (Map.Entry<IDrawing, IDrawingListener> entry : this.drawings.entrySet()) {
            IDrawing key = entry.getKey();
            IDrawingListener value = entry.getValue();
            key.removeIDrawingListener(value);
        }
        this.drawings.clear();
    }

    public double getWidth() {
        return this.canvas.getWidth();
    }

    public double getHeight() {
        return this.canvas.getHeight();
    }

    public void addCanvasListener(@NotNull CanvasListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    protected void notifySizeChanged(int width, int height) {
        for (CanvasListener listener2 : this.listeners) {
            listener2.sizeChange(width, height);
        }
    }

    public final void refresh() {
        this.canvas.schedulePrepare();
    }

    public final void redraw() {
        this.canvas.redraw();
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseMotionListener(l);
    }

    @Override
    public void removeMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.removeMouseListener(l);
    }

    @Override
    public void removeMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.removeMouseMotionListener(l);
    }

    public final void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseWheelListener(l);
    }

    public final void addKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addKeyListener(l);
    }

    public final void addContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addContextMenuListener(l);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Rendering.values().length];
            try {
                nArray[Rendering.Density.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.AlphaBlended.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.Opaque.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.Print.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

