/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.color;

import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.color.MkColor;
import org.mkui.color.MkColorKt;
import org.mkui.color.crossplatform.CPColorKt;

@Metadata(mv={1, 8, 0}, k=5, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\b"}, d2={"alpha", "Lorg/mkui/color/MkColor;", "", "brightenAndSaturate", "brightness", "saturation", "brighter", "darker", "mkui"}, xs="org/mkui/color/MkColor2")
final class MkColor2__MkColorKt {
    @NotNull
    public static final MkColor brighter(@NotNull MkColor $this$brighter) {
        Intrinsics.checkNotNullParameter((Object)$this$brighter, (String)"<this>");
        double FACTOR = 0.7;
        int r = MkColorKt.getURed($this$brighter) & 0xFF;
        int g2 = MkColorKt.getUGreen($this$brighter) & 0xFF;
        int b = MkColorKt.getUBlue($this$brighter) & 0xFF;
        int alpha = MkColorKt.getUAlpha($this$brighter) & 0xFF;
        int i = (int)(1.0 / (1.0 - FACTOR));
        if (r == 0 && g2 == 0 && b == 0) {
            return MkColorKt.colorOf(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g2 > 0 && g2 < i) {
            g2 = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return MkColorKt.colorOf(Math.min((int)((double)r / FACTOR), 255), Math.min((int)((double)g2 / FACTOR), 255), Math.min((int)((double)b / FACTOR), 255), alpha);
    }

    @NotNull
    public static final MkColor alpha(@NotNull MkColor $this$alpha, float alpha) {
        Intrinsics.checkNotNullParameter((Object)$this$alpha, (String)"<this>");
        return MkColorKt.colorOf-bW95L_I(MkColorKt.getURed($this$alpha), MkColorKt.getUGreen($this$alpha), MkColorKt.getUBlue($this$alpha), UByte.constructor-impl((byte)((byte)UnsignedKt.doubleToUInt((double)((float)255 * alpha)))));
    }

    @NotNull
    public static final MkColor darker(@NotNull MkColor $this$darker) {
        Intrinsics.checkNotNullParameter((Object)$this$darker, (String)"<this>");
        double FACTOR = 0.7;
        return MkColorKt.colorOf(Math.max((int)((double)(MkColorKt.getURed($this$darker) & 0xFF) * FACTOR), 0), Math.max((int)((double)(MkColorKt.getUGreen($this$darker) & 0xFF) * FACTOR), 0), Math.max((int)((double)(MkColorKt.getUBlue($this$darker) & 0xFF) * FACTOR), 0), MkColorKt.getUAlpha($this$darker) & 0xFF);
    }

    @NotNull
    public static final MkColor brightenAndSaturate(@NotNull MkColor $this$brightenAndSaturate, float brightness, float saturation) {
        Intrinsics.checkNotNullParameter((Object)$this$brightenAndSaturate, (String)"<this>");
        float[] hsb = CPColorKt.RGBtoHSB(MkColorKt.getURed($this$brightenAndSaturate) & 0xFF, MkColorKt.getUGreen($this$brightenAndSaturate) & 0xFF, MkColorKt.getUBlue($this$brightenAndSaturate) & 0xFF, null);
        if (!(brightness == 0.0f)) {
            hsb[2] = Math.max(0.0f, Math.min(1.0f, hsb[2] + brightness));
        }
        if (!(saturation == 0.0f)) {
            hsb[1] = Math.max(0.0f, Math.min(1.0f, hsb[1] + saturation));
        }
        return MkColorKt.colorOf(CPColorKt.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }
}

