/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.coloring.implementation;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColor;
import org.mkui.coloring.MutableColoring;
import org.mkui.coloring.implementation.AbstractColoring;
import org.mkui.coloring.implementation.SimpleColoringEvent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0096\u0002J\u001f\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/mkui/coloring/implementation/SimpleColoring;", "E", "Lorg/mkui/coloring/implementation/AbstractColoring;", "Lorg/mkui/coloring/MutableColoring;", "()V", "coloredCount", "", "getColoredCount", "()I", "coloring", "", "Lorg/mkui/color/MkColor;", "clearColoring", "", "getColor", "element", "(Ljava/lang/Object;)Lorg/mkui/color/MkColor;", "isColored", "", "(Ljava/lang/Object;)Z", "iterator", "", "setColor", "color", "(Ljava/lang/Object;Lorg/mkui/color/MkColor;)V", "setColorElements", "elements", "", "mkui"})
@StabilityInferred(parameters=0)
public final class SimpleColoring<E>
extends AbstractColoring<E>
implements MutableColoring<E> {
    @NotNull
    private final Map<E, MkColor> coloring = new HashMap();
    public static final int $stable = 8;

    @Override
    public int getColoredCount() {
        return this.coloring.size();
    }

    @Override
    public boolean isColored(E element) {
        return this.coloring.containsKey(element);
    }

    @Override
    @Nullable
    public MkColor getColor(E element) {
        return this.coloring.get(element);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.coloring.keySet().iterator();
    }

    @Override
    public void clearColoring() {
        Set changes = new HashSet();
        for (E e : this) {
            changes.add(e);
        }
        this.coloring.clear();
        this.notifyColoringChanged(new SimpleColoringEvent(changes));
    }

    @Override
    public void setColor(E element, @Nullable MkColor color) {
        if (color != null) {
            Set changes = new HashSet();
            changes.add(element);
            this.coloring.put(element, color);
            this.notifyColoringChanged(new SimpleColoringEvent(changes));
        } else if (this.isColored(element)) {
            Set changes = new HashSet();
            changes.add(element);
            this.coloring.remove(element);
            this.notifyColoringChanged(new SimpleColoringEvent(changes));
        }
    }

    @Override
    public void setColorElements(@NotNull Iterable<? extends E> elements, @Nullable MkColor color) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (color != null) {
            Set changes = new HashSet();
            for (E element : elements) {
                changes.add(element);
                this.coloring.put(element, color);
            }
            if (changes.size() > 0) {
                this.notifyColoringChanged(new SimpleColoringEvent(changes));
            }
        } else {
            Set changes = new HashSet();
            for (E element : elements) {
                if (!this.isColored(element)) continue;
                changes.add(element);
                this.coloring.remove(element);
            }
            if (changes.size() > 0) {
                this.notifyColoringChanged(new SimpleColoringEvent(changes));
            }
        }
    }
}

