/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Crossings;
import org.mkui.geom.Curve;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\"\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u00103\u001a\u00020\bH\u0016J\u0018\u00104\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u00103\u001a\u00020\bH\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0016J\u0010\u00108\u001a\u00020\b2\u0006\u00109\u001a\u000201H\u0016J \u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\bH\u0016J\u0018\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u0003H\u0016R\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0014\u0010\u001e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u0014\u0010 \u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012\u00a8\u0006A"}, d2={"Lorg/mkui/geom/Order1;", "Lorg/mkui/geom/Curve;", "xTop", "", "yTop", "xBot", "yBot", "direction", "", "(DDDDI)V", "order", "getOrder", "()I", "reversedCurve", "getReversedCurve", "()Lorg/mkui/geom/Curve;", "x0", "getX0", "()D", "x1", "getX1", "getXBot", "xMax", "getXMax", "setXMax", "(D)V", "xMin", "getXMin", "setXMin", "getXTop", "y0", "getY0", "y1", "getY1", "getYBot", "getYTop", "TforY", "y", "XforT", "t", "XforY", "YforT", "accumulateCrossings", "", "c", "Lorg/mkui/geom/Crossings;", "compareTo", "other", "yrange", "", "dXforT", "deriv", "dYforT", "enlarge", "Lorg/mkui/geom/Rectangle2D;", "r", "getSegment", "coords", "getSubCurve", "ystart", "yend", "dir", "nextVertical", "t0", "t1", "mkui"})
public final class Order1
extends Curve {
    private final double xTop;
    private final double yTop;
    private final double xBot;
    private final double yBot;
    private double xMin;
    private double xMax;

    public Order1(double xTop, double yTop, double xBot, double yBot, int direction) {
        super(direction);
        this.xTop = xTop;
        this.yTop = yTop;
        this.xBot = xBot;
        this.yBot = yBot;
        if (this.getXTop() < this.getXBot()) {
            this.setXMin(this.getXTop());
            this.setXMax(this.getXBot());
        } else {
            this.setXMin(this.getXBot());
            this.setXMax(this.getXTop());
        }
    }

    @Override
    public double getXTop() {
        return this.xTop;
    }

    @Override
    public double getYTop() {
        return this.yTop;
    }

    @Override
    public double getXBot() {
        return this.xBot;
    }

    @Override
    public double getYBot() {
        return this.yBot;
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    public void setXMin(double d) {
        this.xMin = d;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    public void setXMax(double d) {
        this.xMax = d;
    }

    @Override
    @NotNull
    public Curve getReversedCurve() {
        return new Order1(this.getXTop(), this.getYTop(), this.getXBot(), this.getYBot(), -this.getDirection());
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public double getX0() {
        return this.getDirection() == 1 ? this.getXTop() : this.getXBot();
    }

    @Override
    public double getY0() {
        return this.getDirection() == 1 ? this.getYTop() : this.getYBot();
    }

    @Override
    public double getX1() {
        return this.getDirection() == -1 ? this.getXTop() : this.getXBot();
    }

    @Override
    public double getY1() {
        return this.getDirection() == -1 ? this.getYTop() : this.getYBot();
    }

    @Override
    public double YforT(double t) {
        return this.getYTop() + t * (this.getYBot() - this.getYTop());
    }

    @Override
    public double dXforT(double t, int deriv) {
        return switch (deriv) {
            case 0 -> this.getXTop() + t * (this.getXBot() - this.getXTop());
            case 1 -> this.getXBot() - this.getXTop();
            default -> 0.0;
        };
    }

    @Override
    public double dYforT(double t, int deriv) {
        return switch (deriv) {
            case 0 -> this.getYTop() + t * (this.getYBot() - this.getYTop());
            case 1 -> this.getYBot() - this.getYTop();
            default -> 0.0;
        };
    }

    @Override
    public double XforY(double y) {
        if (this.getXTop() == this.getXBot() || y <= this.getYTop()) {
            return this.getXTop();
        }
        return y >= this.getYBot() ? this.getXBot() : this.getXTop() + (y - this.getYTop()) * (this.getXBot() - this.getXTop()) / (this.getYBot() - this.getYTop());
    }

    @Override
    public boolean accumulateCrossings(@NotNull Crossings c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        double xlo = c.getXLo();
        double ylo = c.getYLo();
        double xhi = c.getXHi();
        double yhi = c.getYHi();
        if (this.getXMin() >= xhi) {
            return false;
        }
        double xstart = 0.0;
        double ystart = 0.0;
        if (this.getYTop() < ylo) {
            if (this.getYBot() <= ylo) {
                return false;
            }
            ystart = ylo;
            xstart = this.XforY(ylo);
        } else {
            if (this.getYTop() >= yhi) {
                return false;
            }
            ystart = this.getYTop();
            xstart = this.getXTop();
        }
        double yend = 0.0;
        double xend = 0.0;
        if (this.getYBot() > yhi) {
            yend = yhi;
            xend = this.XforY(yhi);
        } else {
            yend = this.getYBot();
            xend = this.getXBot();
        }
        if (xstart >= xhi && xend >= xhi) {
            return false;
        }
        if (xstart > xlo || xend > xlo) {
            return true;
        }
        c.record(ystart, yend, this.getDirection());
        return false;
    }

    @Override
    public double TforY(double y) {
        if (y <= this.getYTop()) {
            return 0.0;
        }
        return y >= this.getYBot() ? 1.0 : (y - this.getYTop()) / (this.getYBot() - this.getYTop());
    }

    @Override
    public double XforT(double t) {
        return this.getXTop() + t * (this.getXBot() - this.getXTop());
    }

    @Override
    @NotNull
    public Rectangle2D enlarge(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Rectangle2D r2 = r;
        r2 = r2.add(this.getXTop(), this.getYTop());
        return r2.add(this.getXBot(), this.getYBot());
    }

    @Override
    public double nextVertical(double t0, double t1) {
        return t1;
    }

    @Override
    @NotNull
    public Curve getSubCurve(double ystart, double yend, int dir) {
        if (ystart == this.getYTop() && yend == this.getYBot()) {
            return this.getWithDirection(dir);
        }
        if (this.getXTop() == this.getXBot()) {
            return new Order1(this.getXTop(), ystart, this.getXBot(), yend, dir);
        }
        double num = this.getXTop() - this.getXBot();
        double denom = this.getYTop() - this.getYBot();
        double xstart = this.getXTop() + (ystart - this.getYTop()) * num / denom;
        double xend = this.getXTop() + (yend - this.getYTop()) * num / denom;
        return new Order1(xstart, ystart, xend, yend, dir);
    }

    @Override
    public int compareTo(@NotNull Curve other, @NotNull double[] yrange) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)yrange, (String)"yrange");
        if (!(other instanceof Order1)) {
            return super.compareTo(other, yrange);
        }
        if (yrange[1] <= yrange[0]) {
            throw new UnsupportedOperationException("yrange already screwed up...");
        }
        yrange[1] = Math.min(Math.min(yrange[1], this.getYBot()), other.getYBot());
        if (yrange[1] <= yrange[0]) {
            throw new UnsupportedOperationException("backstepping from " + yrange[0] + " to " + yrange[1]);
        }
        if (this.getXMax() <= ((Order1)other).getXMin()) {
            return this.getXMin() == ((Order1)other).getXMax() ? 0 : -1;
        }
        if (this.getXMin() >= ((Order1)other).getXMax()) {
            return 1;
        }
        double dxa = this.getXBot() - this.getXTop();
        double dya = this.getYBot() - this.getYTop();
        double dxb = other.getXBot() - other.getXTop();
        double dyb = other.getYBot() - other.getYTop();
        double denom = dxb * dya - dxa * dyb;
        double y = 0.0;
        if (!(denom == 0.0)) {
            double num = (this.getXTop() - other.getXTop()) * dya * dyb - this.getYTop() * dxa * dyb + other.getYTop() * dxb * dya;
            y = num / denom;
            if (y <= yrange[0]) {
                y = Math.min(this.getYBot(), other.getYBot());
            } else {
                if (y < yrange[1]) {
                    yrange[1] = y;
                }
                y = Math.max(this.getYTop(), other.getYTop());
            }
        } else {
            y = Math.max(this.getYTop(), other.getYTop());
        }
        return Curve.Companion.orderof(this.XforY(y), other.XforY(y));
    }

    @Override
    public int getSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.getDirection() == 1) {
            coords[0] = this.getXBot();
            coords[1] = this.getYBot();
        } else {
            coords[0] = this.getXTop();
            coords[1] = this.getYTop();
        }
        return 1;
    }
}

