/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Crossings;
import org.mkui.geom.Path2D;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0002?@B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007J\u001e\u0010&\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020)2\u0006\u0010%\u001a\u00020)J&\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020)2\u0006\u0010%\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)J\u0016\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007J\u0011\u0010'\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0086\u0002J\u0011\u0010'\u001a\u00020(2\u0006\u0010,\u001a\u00020.H\u0096\u0002J\u0011\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u00020\fH\u0086\u0002J*\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020)H\u0002J\u0010\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020)H\u0016J\u0012\u0010\u001a\u001a\u00020\u00192\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0018\u0010\u001a\u001a\u00020\u00192\b\u00108\u001a\u0004\u0018\u0001092\u0006\u00107\u001a\u00020)J\u0018\u0010:\u001a\u00020(2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0007J&\u0010;\u001a\u00020(2\u0006\u0010$\u001a\u00020)2\u0006\u0010%\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)J\u0010\u0010;\u001a\u00020(2\u0006\u0010/\u001a\u00020\fH\u0016J\u0006\u0010<\u001a\u00020#J\u0006\u0010=\u001a\u00020#J\u0016\u0010>\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u001f\u00a8\u0006A"}, d2={"Lorg/mkui/geom/Polygon;", "Lorg/mkui/geom/Shape;", "()V", "xpoints", "", "ypoints", "npoints", "", "([I[II)V", "_bounds", "Lorg/mkui/geom/Rectangle;", "boundingBox", "Lorg/mkui/geom/Rectangle2D;", "getBoundingBox", "()Lorg/mkui/geom/Rectangle2D;", "bounds", "getBounds", "()Lorg/mkui/geom/Rectangle;", "bounds2D", "getBounds2D", "getNpoints", "()I", "setNpoints", "(I)V", "pathIterator", "Lorg/mkui/geom/PathIterator;", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "getXpoints", "()[I", "setXpoints", "([I)V", "getYpoints", "setYpoints", "addPoint", "", "x", "y", "calculateBounds", "contains", "", "", "w", "h", "p", "Lorg/mkui/geom/Point;", "Lorg/mkui/geom/Point2D;", "r", "getCrossings", "Lorg/mkui/geom/Crossings;", "xlo", "ylo", "xhi", "yhi", "getFlattenPathIterator", "flatness", "at", "Lorg/mkui/geom/AffineTransform;", "inside", "intersects", "invalidate", "reset", "updateBounds", "Companion", "PolygonPathIterator", "mkui"})
@StabilityInferred(parameters=0)
public final class Polygon
implements Shape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int npoints;
    @NotNull
    private int[] xpoints;
    @NotNull
    private int[] ypoints;
    @Nullable
    private Rectangle _bounds;
    public static final int $stable = 8;
    private static final long serialVersionUID = -6460061437900069969L;
    private static final int MIN_LENGTH = 4;

    public final int getNpoints() {
        return this.npoints;
    }

    public final void setNpoints(int n) {
        this.npoints = n;
    }

    @NotNull
    public final int[] getXpoints() {
        return this.xpoints;
    }

    public final void setXpoints(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.xpoints = nArray;
    }

    @NotNull
    public final int[] getYpoints() {
        return this.ypoints;
    }

    public final void setYpoints(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.ypoints = nArray;
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this._bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        Rectangle rectangle = this._bounds;
        Intrinsics.checkNotNull((Object)rectangle);
        return rectangle;
    }

    public final void calculateBounds(@NotNull int[] xpoints, @NotNull int[] ypoints, int npoints) {
        Intrinsics.checkNotNullParameter((Object)xpoints, (String)"xpoints");
        Intrinsics.checkNotNullParameter((Object)ypoints, (String)"ypoints");
        int boundsMinX = Integer.MAX_VALUE;
        int boundsMinY = Integer.MAX_VALUE;
        int boundsMaxX = Integer.MIN_VALUE;
        int boundsMaxY = Integer.MIN_VALUE;
        for (int i = 0; i < npoints; ++i) {
            int x = xpoints[i];
            boundsMinX = Math.min(boundsMinX, x);
            boundsMaxX = Math.max(boundsMaxX, x);
            int y = ypoints[i];
            boundsMinY = Math.min(boundsMinY, y);
            boundsMaxY = Math.max(boundsMaxY, y);
        }
        this._bounds = new Rectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(@NotNull int[] xpoints, @NotNull int[] ypoints, int npoints) {
        Intrinsics.checkNotNullParameter((Object)xpoints, (String)"xpoints");
        Intrinsics.checkNotNullParameter((Object)ypoints, (String)"ypoints");
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        if (npoints < 0) {
            throw new RuntimeException("npoints < 0");
        }
        this.npoints = npoints;
        this.xpoints = Path2D.Companion.copyOf(xpoints, npoints);
        this.ypoints = Path2D.Companion.copyOf(ypoints, npoints);
    }

    public final void reset() {
        this.npoints = 0;
        this._bounds = null;
    }

    public final void invalidate() {
        this._bounds = null;
    }

    public final void addPoint(int x, int y) {
        if (this.npoints >= this.xpoints.length || this.npoints >= this.ypoints.length) {
            int newLength = this.npoints * 2;
            if (newLength < 4) {
                newLength = 4;
            } else if ((newLength & newLength - 1) != 0) {
                newLength = Integer.highestOneBit(newLength);
            }
            this.xpoints = Path2D.Companion.copyOf(this.xpoints, newLength);
            this.ypoints = Path2D.Companion.copyOf(this.ypoints, newLength);
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        int n = this.npoints;
        this.npoints = n + 1;
        if (this._bounds != null) {
            this.updateBounds(x, y);
        }
    }

    public final void updateBounds(int x, int y) {
        double d = x;
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNull((Object)rectangle);
        if (d < rectangle.getX()) {
            Rectangle rectangle2 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle2);
            Rectangle rectangle3 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle3);
            int n = rectangle3.getIwidth();
            Rectangle rectangle4 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle4);
            rectangle2.setIwidth(n + (rectangle4.getIx() - x));
            Rectangle rectangle5 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle5);
            rectangle5.setIx(x);
        } else {
            Rectangle rectangle6 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle6);
            Rectangle rectangle7 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle7);
            int n = rectangle7.getIwidth();
            Rectangle rectangle8 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle8);
            rectangle6.setIwidth(Math.max(n, x - rectangle8.getIx()));
        }
        double d2 = y;
        Rectangle rectangle9 = this.getBounds();
        Intrinsics.checkNotNull((Object)rectangle9);
        if (d2 < rectangle9.getY()) {
            Rectangle rectangle10 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle10);
            Rectangle rectangle11 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle11);
            int n = rectangle11.getIheight();
            Rectangle rectangle12 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle12);
            rectangle10.setIheight(n + (rectangle12.getIy() - y));
            Rectangle rectangle13 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle13);
            rectangle13.setIy(y);
        } else {
            Rectangle rectangle14 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle14);
            Rectangle rectangle15 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle15);
            int n = rectangle15.getIheight();
            Rectangle rectangle16 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle16);
            rectangle14.setIheight(Math.max(n, y - rectangle16.getIy()));
        }
    }

    public final boolean contains(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    public final boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public final boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.getBoundingBox().contains(x, y)) {
            return false;
        }
        int hits = 0;
        int lastx = this.xpoints[this.npoints - 1];
        int lasty = this.ypoints[this.npoints - 1];
        int curx = 0;
        int cury = 0;
        int i = 0;
        while (i < this.npoints) {
            curx = this.xpoints[i];
            cury = this.ypoints[i];
            if (cury == lasty) {
                lastx = curx;
                lasty = cury;
                ++i;
                continue;
            }
            int leftx = 0;
            if (curx < lastx) {
                if (x >= (double)lastx) {
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                leftx = curx;
            } else {
                if (x >= (double)curx) {
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                leftx = lastx;
            }
            double test1 = 0.0;
            double test2 = 0.0;
            if (cury < lasty) {
                if (y < (double)cury || y >= (double)lasty) {
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                if (x < (double)leftx) {
                    ++hits;
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                test1 = x - (double)curx;
                test2 = y - (double)cury;
            } else {
                if (y < (double)lasty || y >= (double)cury) {
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                if (x < (double)leftx) {
                    ++hits;
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                test1 = x - (double)lastx;
                test2 = y - (double)lasty;
            }
            if (test1 < test2 / (double)(lasty - cury) * (double)(lastx - curx)) {
                ++hits;
            }
            lastx = curx;
            lasty = cury;
            ++i;
        }
        return hits & true;
    }

    @Deprecated(message="As of JDK version 1.1,\n      replaced by <code>getBounds()</code>.")
    @NotNull
    public final Rectangle2D getBoundingBox() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this._bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNull((Object)rectangle);
        return rectangle.getBounds2D();
    }

    @Deprecated(message="As of JDK version 1.1,\n      replaced by <code>contains(int, int)</code>.")
    public final boolean inside(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        return this.getBoundingBox();
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross == null || !cross.isEmpty();
    }

    private final Crossings getCrossings(double xlo, double ylo, double xhi, double yhi) {
        Crossings cross = new Crossings.EvenOdd(xlo, ylo, xhi, yhi);
        int lastx = this.xpoints[this.npoints - 1];
        int lasty = this.ypoints[this.npoints - 1];
        int n = this.npoints;
        for (int i = 0; i < n; ++i) {
            int curx = this.xpoints[i];
            int cury = this.ypoints[i];
            if (cross.accumulateLine(lastx, lasty, curx, cury)) {
                return null;
            }
            lastx = curx;
            lasty = cury;
        }
        return cross;
    }

    @Override
    @NotNull
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return new PolygonPathIterator(this, at);
    }

    @Override
    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return this.getPathIterator(null, flatness);
    }

    @NotNull
    public final PathIterator getPathIterator(@Nullable AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public final boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean contains(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross != null && cross.covers(y, y + h);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/mkui/geom/Polygon$Companion;", "", "()V", "MIN_LENGTH", "", "serialVersionUID", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u0096\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/mkui/geom/Polygon$PolygonPathIterator;", "Lorg/mkui/geom/PathIterator;", "poly", "Lorg/mkui/geom/Polygon;", "at", "Lorg/mkui/geom/AffineTransform;", "(Lorg/mkui/geom/Polygon;Lorg/mkui/geom/AffineTransform;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "isDone", "", "()Z", "getPoly", "()Lorg/mkui/geom/Polygon;", "transform", "getTransform", "()Lorg/mkui/geom/AffineTransform;", "windingRule", "getWindingRule", "currentSegment", "coords", "", "", "next", "", "mkui"})
    public static final class PolygonPathIterator
    implements PathIterator {
        @NotNull
        private final Polygon poly;
        @Nullable
        private final AffineTransform transform;
        private int index;

        public PolygonPathIterator(@NotNull Polygon poly, @Nullable AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
            this.poly = poly;
            this.transform = at;
            if (this.poly.getNpoints() == 0) {
                this.index = 1;
            }
        }

        @NotNull
        public final Polygon getPoly() {
            return this.poly;
        }

        @Nullable
        public final AffineTransform getTransform() {
            return this.transform;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > this.poly.getNpoints();
        }

        @Override
        public void next() {
            int n = this.index;
            this.index = n + 1;
        }

        @Override
        public int currentSegment(@NotNull float[] coords) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                if (this.index >= this.poly.getNpoints()) {
                    return 4;
                }
                coords[0] = this.poly.getXpoints()[this.index];
                coords[1] = this.poly.getYpoints()[this.index];
                AffineTransform affineTransform = this.transform;
                if (affineTransform == null) break block1;
                affineTransform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(@NotNull double[] coords) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                if (this.index >= this.poly.getNpoints()) {
                    return 4;
                }
                coords[0] = this.poly.getXpoints()[this.index];
                coords[1] = this.poly.getYpoints()[this.index];
                AffineTransform affineTransform = this.transform;
                if (affineTransform == null) break block1;
                affineTransform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

