/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.AbstractRectangle2D;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Shape;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u000e\bf\u0018\u00002\u00020\u0001:\u0001'J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H&J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H&J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H&J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H&J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H&J(\u0010 \u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H&J(\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H&J\b\u0010&\u001a\u00020\u0000H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0012\u0010\f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u0012\u0010\u0010\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0012\u0010\u0012\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0012\u0010\u0014\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005R\u0012\u0010\u0016\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005\u00a8\u0006("}, d2={"Lorg/mkui/geom/Rectangle2D;", "Lorg/mkui/geom/Shape;", "centerX", "", "getCenterX", "()D", "centerY", "getCenterY", "height", "getHeight", "maxX", "getMaxX", "maxY", "getMaxY", "minX", "getMinX", "minY", "getMinY", "width", "getWidth", "x", "getX", "y", "getY", "add", "contains", "", "w", "h", "createIntersection", "r", "createUnion", "intersects", "intersectsLine", "x1", "y1", "x2", "y2", "normalize", "Double", "mkui"})
public interface Rectangle2D
extends Shape {
    public double getX();

    public double getY();

    public double getWidth();

    public double getHeight();

    public double getMinX();

    public double getMinY();

    public double getMaxX();

    public double getMaxY();

    public double getCenterX();

    public double getCenterY();

    public boolean intersectsLine(double var1, double var3, double var5, double var7);

    @NotNull
    public Rectangle2D createIntersection(@NotNull Rectangle2D var1);

    @NotNull
    public Rectangle2D createUnion(@NotNull Rectangle2D var1);

    @NotNull
    public Rectangle2D normalize();

    @NotNull
    public Rectangle2D add(double var1, double var3);

    public boolean intersects(double var1, double var3, double var5, double var7);

    public boolean contains(double var1, double var3, double var5, double var7);

    public boolean contains(double var1, double var3);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Rectangle getBounds(@NotNull Rectangle2D $this) {
            return Shape.DefaultImpls.getBounds($this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J(\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J(\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/mkui/geom/Rectangle2D$Double;", "Lorg/mkui/geom/AbstractRectangle2D;", "x", "", "y", "width", "height", "(DDDD)V", "getHeight", "()D", "isEmpty", "", "()Z", "isNormalized", "getWidth", "getX", "getY", "add", "Lorg/mkui/geom/Rectangle2D;", "r", "contains", "w", "h", "intersects", "normalize", "toString", "", "Companion", "mkui"})
    @StabilityInferred(parameters=0)
    public static class Double
    extends AbstractRectangle2D {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double x;
        private final double y;
        private final double width;
        private final double height;
        public static final int $stable;

        public Double(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @NotNull
        public final Double add(@NotNull Rectangle2D r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            double x1 = Math.min(this.getMinX(), r.getMinX());
            double x2 = Math.max(this.getMaxX(), r.getMaxX());
            double y1 = Math.min(this.getMinY(), r.getMinY());
            double y2 = Math.max(this.getMaxY(), r.getMaxY());
            return new Double(x1, y1, x2 - x1, y2 - y1);
        }

        @Override
        @NotNull
        public Rectangle2D add(double x, double y) {
            double x1 = Math.min(this.getMinX(), x);
            double x2 = Math.max(this.getMaxX(), x);
            double y1 = Math.min(this.getMinY(), y);
            double y2 = Math.max(this.getMaxY(), y);
            return new Double(x1, y1, x2 - x1, y2 - y1);
        }

        @NotNull
        public String toString() {
            return "Rectangle2D.Double{x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "}";
        }

        @Override
        @NotNull
        public Double normalize() {
            if (this.isNormalized()) {
                return this;
            }
            double normalizedX = this.getX();
            double normalizedWidth = this.getWidth();
            if (normalizedWidth < 0.0) {
                normalizedWidth = -normalizedWidth;
                normalizedX -= normalizedWidth;
            }
            double normalizedHeight = this.getHeight();
            double normalizedY = this.getY();
            if (normalizedHeight < 0.0) {
                normalizedHeight = -normalizedHeight;
                normalizedY -= normalizedHeight;
            }
            return new Double(normalizedX, normalizedY, normalizedWidth, normalizedHeight);
        }

        private final boolean isNormalized() {
            return this.getWidth() >= 0.0 && this.getHeight() >= 0.0;
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            return this.intersects(new Double(x, y, w, h));
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
                return false;
            }
            double x0 = x;
            double y0 = y;
            return x >= x0 && y >= y0 && x + w <= x0 + this.getWidth() && y + h <= y0 + this.getHeight();
        }

        @Override
        public boolean contains(double x, double y) {
            return this.contains(new Point2D.Double(x, y));
        }

        public final boolean isEmpty() {
            return this.getWidth() <= 0.0 || this.getHeight() <= 0.0;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/mkui/geom/Rectangle2D$Double$Companion;", "", "()V", "frameFromDiagonal", "Lorg/mkui/geom/Rectangle2D$Double;", "x1", "", "y1", "x2", "y2", "mkui"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Double frameFromDiagonal(double x1, double y1, double x2, double y2) {
                double t;
                double x12 = x1;
                double y12 = y1;
                double x22 = x2;
                double y22 = y2;
                if (x22 < x12) {
                    t = x12;
                    x12 = x22;
                    x22 = t;
                }
                if (y22 < y12) {
                    t = y12;
                    y12 = y22;
                    y22 = t;
                }
                return new Double(x12, y12, x22 - x12, y22 - y12);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

